using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace Movella.Xsens
{
    /// <summary>
    /// Extension methods for Unity objects. GetOrAddComponent is a utility method for adding a component to a GameObject
    /// It takes a generic type parameter and returns the component of that type if it exists, otherwise it adds the component
    /// </summary>
    public static class Utilities
    {
        public static T GetOrAddComponent<T>(this GameObject go) where T : Component
        {
            if (go == null) return null;

            if (!go.TryGetComponent<T>(out T comp))
            {
                comp = go.AddComponent<T>();
            }

            return comp;
        }
    }
}