# MVN Unity Plugin
_See_ `/Docs/Unity MVN Plugin Workflow.pdf` _for detailed documentation._
## **Installation**

1. Open Unity. Navigate to **Window \> Package Manager**.  
   ![image](https://github.com/user-attachments/assets/932a98a9-bb30-4f2b-97d7-536c2105eb42)
     
3. Click the ‘+’ button at the top left and select **Install package from disk…** and then select the **package.json** file inside the plugin folder. This will install the plugin to the project and register the plugin’s location on disk.  
   ![image](https://github.com/user-attachments/assets/c3a8c78f-4c1a-4f1f-98f9-eacb87c7efe5)

4. The plugin requires Unity’s ‘Live Capture’ plugin. If it's not already installed in the project, you can use the package manager to install it from the Unity Registry.
* NOTE: When installing a plugin from disk in Unity, the plugin files will not be copied into a dedicated plugin location as is the case with some other DCC software. This means that if the plugin files are modified or removed It will stop working correctly in Unity. Make sure the plugin is saved to a safe location before installing.

## **Sample Scene**

1. The plugin includes sample assets with a pre-configured scene. To import the sample assets select the plugin in the package manager, open the samples tab and click the import button.    
2. The streaming demo scene will be imported to:  
   **\<PROJECT\_ROOT\>/Assets/Samples/Xsens/2025.0.0/Streaming Demo/Scenes**  
   ![image](https://github.com/user-attachments/assets/dba512cb-bb65-4534-be0e-6e5c555dfbad)


## **UI**

After the plugin is installed, Navigate to **Window \> Xsens Live Stream** to open the Xsens streaming panel.
![image](https://github.com/user-attachments/assets/4953d077-e831-4ad6-8475-1b13730e6f0d)


## **Streaming**

1. Make sure MVN is broadcasting to the Unity PC’s IP address and the “Listen Port” field in Unity is set to the port number the stream is broadcasting to.   
   Required stream options are:  
   1. Quaternion  
   2. Character Meta Data  
   3. Timecode (for recording with Unity take recorder)

![image](https://github.com/user-attachments/assets/d1e1e359-6d53-4c14-8987-49ed29f69758)


2. Click **Start Stream**.   
   To connect the stream to your character refer to the [**Retargeting Section**](#retargeting-\(new-ui-method\)).  
3. Open the **Connections** window to view the status of all Unity Live Capture devices. The Xsens Connection will be listed here with its status displayed.  
   ![image](https://github.com/user-attachments/assets/bd203505-e7d2-4013-9ede-80a95b658970)
 
     
     
     
4. Open the **Diagnostics** panel to verify the stream is connected and the plugin is receiving data. Stream entity information can be viewed under its corresponding stream dropdown. Object streams will display each tracker name and transform in the body section  
   ![image](https://github.com/user-attachments/assets/3a108d00-cca8-4ab1-aa86-4b48a88e8d8b)


## **Retargeting (New UI Method)** {#retargeting-(new-ui-method)}

1. To begin retargeting select a desired rig in the target field, alternatively you can drag and drop from the scene hierarchy into the field. You can at any time switch between target objects in this field. Any object you have set up will remain set up even if you alter this field.  
   ![image](https://github.com/user-attachments/assets/f50a5099-e130-45c1-8665-44980b2a24c4)

     
2. Once you have a connected stream from MVN and a target object selected, you will see an Xsens Source dropdown as well as several device options. The Xsens Source dropdown will show all available streams from Xsens. Changing between actors and objects will alter the device that is added to your object and therefore the options that are available to you.  
   ![image](https://github.com/user-attachments/assets/ff8768ae-75d3-49ff-9f4d-ba9d5a72936d)


## **Retargeting (Component Method)**

The new UI Method is more user friendly and allows for more options however you can still retarget the old way by setting the components manually.

1. With your rig selected, go to the inspector window and click on the Add Component button.  
   ![image](https://github.com/user-attachments/assets/016eb5e4-572a-4d50-9e8c-87dc207df24d)

2. Search for and then add either the Xsens Actor Device or the Xsens Object Device.  
   ![image](https://github.com/user-attachments/assets/75be38db-096f-4c2c-9a60-76bbba0dd978)

3. These devices are mostly unchanged from the previous version of the plugin with largely similar options to the new ui, apart from needing to reference streams by ID rather than name.  
4. Any changes you make to the component device will be reflected in the new ui if you’re using that as well, and likewise any changes made in the new ui will be reflected in the component device.

## **Offline Retargeting**

Offline retargeting is done through Unity's native workflow. Both the target and the imported animation need to have Humanoid configurations (MVN T-pose no longer matters, as long as both are configured the same). The imported animation can then be added to an animator controller which is used to drive the target.

[https://base.movella.com/s/article/FBX-import-into-Unity?language=en\_US](https://base.movella.com/s/article/FBX-import-into-Unity?language=en_US)

## **Remote Controls**

The Remote Control Panel is split into two sections: playback and live session.  
These options provide a convenient way to control MVN sessions without interacting with MVN’s GUI. For the controls to work, the user must properly set the **Host Address** (The IP address of the computer running the MVN session) and the **Remote Control Port** (The port  number specified in MVN remote control settings).  
 ![image](https://github.com/user-attachments/assets/562b5aa9-5996-4b08-9bd2-907dae1d5e30)
 
**Playback Controls:**  
The playback controls section consists of the timeline and the playback buttons. The buttons reflect the playback controls available in MVN. The timeline includes a scrubbable playhead that will synchronize with MVN’s playhead when scrubbed or playback is stopped. **Note:** The playhead position will not update in real-time during playback. 

The numbers on the far left and right represent the session’s start and end frames and will automatically update based on the active window in MVN. The input fields on either side of the timeline allow the user to set a min/max scrub range for the unity playhead. The current frame is displayed to the right of the playhead.

**Live Session Controls & Recording:**  
The top of the live session controls section consists of fields to input the take name and number. Below this there are two buttons, the button on the left will send a ‘move character to origin’ request to MVN. The button on the right will send an ‘axis reset’ request. The **Start MVN Recording** button will send a start capture request to MVN and will send along the take name/number which MVN will use to set the output file name. The **Trigger Take Recorder** checkbox will cause the record button to also trigger recording in Unity’s take recorder. The **Take Recorder** button will simply open Unity’s take recorder panel.  
**Note:** The recording interface is designed to provide a convenient way to control MVN’s record state from Unity. While it can trigger Unity’s Take Recorder, it is not meant to be used as a replacement for Take Recorder. If the user wants to record the animation stream directly to Unity assets, they should refer to [Unity’s Take Recorder Documentation](https://docs.unity3d.com/Packages/com.unity.live-capture@4.0/manual/ref-window-take-recorder.html).
