﻿using System;
using UnityEngine;
using UnityEditor;
using System.Collections.Generic;

// Templates for tpose and mapping for all requested rig types
public static class TPoseLibrary
{
    public static Dictionary<HumanBodyBones, string> HumanBoneStrings = new Dictionary<HumanBodyBones, string>
    {
        { HumanBodyBones.Hips, "Hips" },
        { HumanBodyBones.Spine, "Spine" },
        { HumanBodyBones.Chest, "Chest" },
        { HumanBodyBones.UpperChest, "UpperChest" },

        { HumanBodyBones.Neck, "Neck" },
        { HumanBodyBones.Head, "Head" },

        { HumanBodyBones.LeftShoulder, "LeftShoulder" },
        { HumanBodyBones.LeftUpperArm, "LeftUpperArm" },
        { HumanBodyBones.LeftLowerArm, "LeftLowerArm" },
        { HumanBodyBones.LeftHand, "LeftHand" },

        { HumanBodyBones.RightShoulder, "RightShoulder" },
        { HumanBodyBones.RightUpperArm, "RightUpperArm" },
        { HumanBodyBones.RightLowerArm, "RightLowerArm" },
        { HumanBodyBones.RightHand, "RightHand" },

        { HumanBodyBones.LeftUpperLeg, "LeftUpperLeg" },
        { HumanBodyBones.LeftLowerLeg, "LeftLowerLeg" },
        { HumanBodyBones.LeftFoot, "LeftFoot" },
        { HumanBodyBones.LeftToes, "LeftToes" },

        { HumanBodyBones.RightUpperLeg, "RightUpperLeg" },
        { HumanBodyBones.RightLowerLeg, "RightLowerLeg" },
        { HumanBodyBones.RightFoot, "RightFoot" },
        { HumanBodyBones.RightToes, "RightToes" },

        { HumanBodyBones.LeftEye, "LeftEye" },
        { HumanBodyBones.RightEye, "RightEye" },
        { HumanBodyBones.Jaw, "Jaw" },

        { HumanBodyBones.LeftThumbProximal, "Left Thumb Proximal" },
        { HumanBodyBones.LeftThumbIntermediate, "Left Thumb Intermediate" },
        { HumanBodyBones.LeftThumbDistal, "Left Thumb Distal" },
        { HumanBodyBones.LeftIndexProximal, "Left Index Proximal" },
        { HumanBodyBones.LeftIndexIntermediate, "Left Index Intermediate" },
        { HumanBodyBones.LeftIndexDistal, "Left Index Distal" },
        { HumanBodyBones.LeftMiddleProximal, "Left Middle Proximal" },
        { HumanBodyBones.LeftMiddleIntermediate, "Left Middle Intermediate" },
        { HumanBodyBones.LeftMiddleDistal, "Left Middle Distal" },
        { HumanBodyBones.LeftRingProximal, "Left Ring Proximal" },
        { HumanBodyBones.LeftRingIntermediate, "Left Ring Intermediate" },
        { HumanBodyBones.LeftRingDistal, "Left Ring Distal" },
        { HumanBodyBones.LeftLittleProximal, "Left Little Proximal" },
        { HumanBodyBones.LeftLittleIntermediate, "Left Little Intermediate" },
        { HumanBodyBones.LeftLittleDistal, "Left Little Distal" },

        { HumanBodyBones.RightThumbProximal, "Right Thumb Proximal" },
        { HumanBodyBones.RightThumbIntermediate, "Right Thumb Intermediate" },
        { HumanBodyBones.RightThumbDistal, "Right Thumb Distal" },
        { HumanBodyBones.RightIndexProximal, "Right Index Proximal" },
        { HumanBodyBones.RightIndexIntermediate, "Right Index Intermediate" },
        { HumanBodyBones.RightIndexDistal, "Right Index Distal" },
        { HumanBodyBones.RightMiddleProximal, "Right Middle Proximal" },
        { HumanBodyBones.RightMiddleIntermediate, "Right Middle Intermediate" },
        { HumanBodyBones.RightMiddleDistal, "Right Middle Distal" },
        { HumanBodyBones.RightRingProximal, "Right Ring Proximal" },
        { HumanBodyBones.RightRingIntermediate, "Right Ring Intermediate" },
        { HumanBodyBones.RightRingDistal, "Right Ring Distal" },
        { HumanBodyBones.RightLittleProximal, "Right Little Proximal" },
        { HumanBodyBones.RightLittleIntermediate, "Right Little Intermediate" },
        { HumanBodyBones.RightLittleDistal, "Right Little Distal" }
    };
    public static Dictionary<HumanBodyBones, List<string>> AutoTemplate = new Dictionary<HumanBodyBones, List<string>>
    {
        { HumanBodyBones.Hips, new List<string> { "spine_fk_null", "bd_spine_01_jnt", "hips", "hip", "pelvis", "spine_01", "spine" } },
        { HumanBodyBones.Spine, new List<string> { "hip_fk_00_jnt", "waist", "spine", "spine1", "spine_1", "spine_01", "spine01", "spine_lower", "lower_spine", "spine_02", "hip" } },
        { HumanBodyBones.Chest, new List<string> { "midd_fk_01_jnt", "chest", "spine2", "spine_2", "spine_02", "spine02", "spine_upper", "spine1", "spine_1", "spine_01", "spine01", "ribcage", "spine_03", "midd" } },
        { HumanBodyBones.UpperChest, new List<string> { "chest_fk_01_jnt", "upper_chest", "upperchest", "spine3", "spine_3", "spine_03", "spine03", "thorax", "spine2", "spine_2", "spine_02", "spine02", "upper_torso", "chest" } },

        { HumanBodyBones.Neck, new List<string> { "neck", "cervical", "neck_base" } },
        { HumanBodyBones.Head, new List<string> { "head", "head_top", "skull", "cranium" } },

        { HumanBodyBones.LeftShoulder, new List<string> { "left_shoulder", "clavicle_l", "shoulder_l", "leftshoulder", "l_clavicle", "l_bd_collar", "l_fk_collar" } },
        { HumanBodyBones.LeftUpperArm, new List<string> { "left_upper_arm", "left_upperarm", "upperarm_l", "l_upperarm", "arm_l", "leftarm", "l_arm", "l_bd_nb_shoulder", "l_fk_shoulder" } },
        { HumanBodyBones.LeftLowerArm, new List<string> { "left_lower_arm", "left_lowerarm", "forearm_l", "l_forearm", "lowerarm_l", "leftforearm", "l_bd_nb_forearm", "l_fk_elbow" } },
        { HumanBodyBones.LeftHand, new List<string> { "left_hand", "lefthand", "hand_l", "l_hand", "wrist_l", "l_wrist", "l_bd_wrist", "l_fk_hand" } },

        { HumanBodyBones.RightShoulder, new List<string> { "right_shoulder", "clavicle_r", "r_shoulder", "shoulder_r", "rightshoulder", "r_clavicle", "r_bd_collar", "r_fk_collar" } },
        { HumanBodyBones.RightUpperArm, new List<string> { "right_upper_arm", "right_upperarm", "upperarm_r", "r_upperarm", "arm_r", "rightarm", "r_arm", "r_bd_nb_shoulder", "r_fk_shoulder" } },
        { HumanBodyBones.RightLowerArm, new List<string> { "right_lower_arm", "right_lowerarm", "forearm_r", "r_forearm", "lowerarm_r", "rightforearm", "r_bd_nb_forearm", "r_fk_elbow" } },
        { HumanBodyBones.RightHand, new List<string> { "right_hand", "righthand", "hand_r", "r_hand", "wrist_r", "r_wrist", "r_bd_wrist", "r_fk_hand" } },

        { HumanBodyBones.LeftUpperLeg, new List<string> { "left_upper_leg", "left_upperleg", "thigh_l", "l_thigh", "leg_upper_l", "leftupleg", "l_bd_nb_hip", "l_hip" } },
        { HumanBodyBones.LeftLowerLeg, new List<string> { "left_lower_leg", "left_lowerleg", "shin_l", "calf_l", "l_calf", "leftleg", "l_shin", "l_bd_nb_knee", "l_knee" } },
        { HumanBodyBones.LeftFoot, new List<string> { "left_foot", "foot_l", "l_foot", "ankle_l", "leftfoot", "l_ankle", "l_bd_nb_ankle" } },
        { HumanBodyBones.LeftToes, new List<string> { "left_toes", "toe_l", "l_toe", "l_toebase", "toes_l", "lefttoebase", "l_toes", "l_bd_nb_ball" } },

        { HumanBodyBones.RightUpperLeg, new List<string> { "right_upper_leg", "right_upperleg", "thigh_r", "r_thigh", "leg_upper_r", "rightupleg", "r_bd_nb_hip", "r_hip" } },
        { HumanBodyBones.RightLowerLeg, new List<string> { "right_lower_leg", "right_lowerleg", "shin_r", "calf_r", "r_calf", "rightleg", "r_shin", "r_bd_nb_knee", "r_knee" } },
        { HumanBodyBones.RightFoot, new List<string> { "right_foot", "foot_r", "r_foot", "ankle_r", "rightfoot", "r_ankle", "r_bd_nb_ankle" } },
        { HumanBodyBones.RightToes, new List<string> { "right_toes", "toe_r", "r_toe", "r_toebase", "toes_r", "righttoebase", "r_toes", "r_bd_nb_ball" } },

        { HumanBodyBones.LeftEye, new List<string> { "left_eye", "eye_l", "l_eye" } },
        { HumanBodyBones.RightEye, new List<string> { "right_eye", "eye_r", "r_eye" } },
        { HumanBodyBones.Jaw, new List<string> { "jaw", "mandible", "lower_jaw" } },

        { HumanBodyBones.LeftThumbProximal, new List<string> { "left_thumb_1", "thumb1_l", "l_thumb_1", "l_thumb1", "thumb_01_l", "lefthandthumb1", "thumb.01.l", "l_bd_fk_thumb_root", "l_thumb_base", "left_thumbproximal" } },
        { HumanBodyBones.LeftThumbIntermediate, new List<string> { "left_thumb_2", "thumb2_l", "l_thumb_2", "l_thumb2", "thumb_02_l", "lefthandthumb2", "thumb.02.l", "l_bd_fk_thumb_base", "l_thumb_mid", "left_thumbintermediate" } },
        { HumanBodyBones.LeftThumbDistal, new List<string> { "left_thumb_3", "thumb3_l", "l_thumb_3", "l_thumb3", "thumb_03_l", "lefthandthumb3", "thumb.03.l", "l_bd_fk_thumb_mid", "l_thumb_top", "left_thumbdistal" } },
        { HumanBodyBones.LeftIndexProximal, new List<string> { "left_index_1", "index1_l", "l_index_1", "l_index1", "index_01_l", "lefthandindex1", "index.01.l", "l_bd_fk_finger_base_jnt", "l_finger_middle_jnt", "left_indexproximal" } },
        { HumanBodyBones.LeftIndexIntermediate, new List<string> { "left_index_2", "index2_l", "l_index_2", "l_index2", "index_02_l", "lefthandindex2", "index.02.l", "l_bd_fk_finger_mid_jnt", "l_finger_top_jnt", "left_indexintermediate" } },
        { HumanBodyBones.LeftIndexDistal, new List<string> { "left_index_3", "index3_l", "l_index_3", "l_index3", "index_03_l", "lefthandindex3", "index.03.l", "l_bd_fk_finger_top_jnt", "l_finger_end_jnt", "left_indexdistal" } },
        { HumanBodyBones.LeftMiddleProximal, new List<string> { "left_middle_1", "middle1_l", "l_middle_1", "l_middle1", "l_mid1", "middle_01_l", "lefthandmiddle1", "middle.01.l", "l_bd_fk_finger_base_jnt_1", "l_finger_middle_jnt_1", "left_middleproximal" } },
        { HumanBodyBones.LeftMiddleIntermediate, new List<string> { "left_middle_2", "middle2_l", "l_middle_2", "l_middle2", "l_mid2", "middle_02_l", "lefthandmiddle2", "middle.02.l", "l_bd_fk_finger_mid_jnt_1", "l_finger_top_jnt_1", "left_middleintermediate" } },
        { HumanBodyBones.LeftMiddleDistal, new List<string> { "left_middle_3", "middle3_l", "l_middle_3", "l_middle3", "l_mid3", "middle_03_l", "lefthandmiddle3", "middle.03.l", "l_bd_fk_finger_top_jnt_1", "l_finger_end_jnt_1", "left_middledistal" } },
        { HumanBodyBones.LeftRingProximal, new List<string> { "left_ring_1", "ring1_l", "l_ring_1", "l_ring1", "ring_01_l", "lefthandring1", "ring.01.l", "l_bd_fk_finger_base_jnt_2", "l_finger_middle_jnt_2", "left_ringproximal" } },
        { HumanBodyBones.LeftRingIntermediate, new List<string> { "left_ring_2", "ring2_l", "l_ring_2", "l_ring2", "ring_02_l", "lefthandring2", "ring.02.l", "l_bd_fk_finger_mid_jnt_2", "l_finger_top_jnt_2", "left_ringintermediate" } },
        { HumanBodyBones.LeftRingDistal, new List<string> { "left_ring_3", "ring3_l", "l_ring_3", "l_ring3", "ring_03_l", "lefthandring3", "ring.03.l", "l_bd_fk_finger_top_jnt_2", "l_finger_end_jnt_2", "left_ringdistal" } },
        { HumanBodyBones.LeftLittleProximal, new List<string> { "left_little_1", "pinky1_l", "l_pinky_1", "l_pinky1", "pinky_01_l", "lefthandpinky1", "pinky.01.l", "l_bd_fk_finger_base_jnt_3", "l_finger_middle_jnt_3", "left_pinkyproximal" } },
        { HumanBodyBones.LeftLittleIntermediate, new List<string> { "left_little_2", "pinky2_l", "l_pinky_2", "l_pinky2", "pinky_02_l", "lefthandpinky2", "pinky.02.l", "l_bd_fk_finger_mid_jnt_3", "l_finger_top_jnt_3", "left_pinkyintermediate" } },
        { HumanBodyBones.LeftLittleDistal, new List<string> { "left_little_3", "pinky3_l", "l_pinky_3", "l_pinky3", "pinky_03_l", "lefthandpinky3", "pinky.03.l", "l_bd_fk_finger_top_jnt_3", "l_finger_end_jnt_3", "left_pinkydistal" } },

        { HumanBodyBones.RightThumbProximal, new List<string> { "right_thumb_1", "thumb1_r", "r_thumb_1", "r_thumb1", "thumb_01_r", "righthandthumb1", "thumb.01.r", "r_bd_fk_thumb_root", "r_thumb_base", "right_thumbproximal" } },
        { HumanBodyBones.RightThumbIntermediate, new List<string> { "right_thumb_2", "thumb2_r", "r_thumb_2", "r_thumb2", "thumb_02_r", "righthandthumb2", "thumb.02.r", "r_bd_fk_thumb_base", "r_thumb_mid", "right_thumbintermediate" } },
        { HumanBodyBones.RightThumbDistal, new List<string> { "right_thumb_3", "thumb3_r", "r_thumb_3", "r_thumb3", "thumb_03_r", "righthandthumb3", "thumb.03.r", "r_bd_fk_thumb_mid", "r_thumb_top", "right_thumbdistal" } },
        { HumanBodyBones.RightIndexProximal, new List<string> { "right_index_1", "index1_r", "r_index_1", "r_index1", "index_01_r", "righthandindex1", "index.01.r", "r_bd_fk_finger_base_jnt", "r_finger_middle_jnt", "right_indexproximal" } },
        { HumanBodyBones.RightIndexIntermediate, new List<string> { "right_index_2", "index2_r", "r_index_2", "r_index2", "index_02_r", "righthandindex2", "index.02.r", "r_bd_fk_finger_mid_jnt", "r_finger_top_jnt", "right_indexintermediate" } },
        { HumanBodyBones.RightIndexDistal, new List<string> { "right_index_3", "index3_r", "r_index_3", "r_index3", "index_03_r", "righthandindex3", "index.03.r", "r_bd_fk_finger_top_jnt", "r_finger_end_jnt", "right_indexdistal" } },
        { HumanBodyBones.RightMiddleProximal, new List<string> { "right_middle_1", "middle1_r", "r_middle_1", "r_middle1", "r_mid1", "middle_01_r", "righthandmiddle1", "middle.01.r", "r_bd_fk_finger_base_jnt_1", "r_finger_middle_jnt_1", "right_middleproximal" } },
        { HumanBodyBones.RightMiddleIntermediate, new List<string> { "right_middle_2", "middle2_r", "r_middle_2", "r_middle2", "r_mid2", "middle_02_r", "righthandmiddle2", "middle.02.r", "r_bd_fk_finger_mid_jnt_1", "r_finger_top_jnt_1", "right_middleintermediate" } },
        { HumanBodyBones.RightMiddleDistal, new List<string> { "right_middle_3", "middle3_r", "r_middle_3", "r_middle3", "r_mid3", "middle_03_r", "righthandmiddle3", "middle.03.r", "r_bd_fk_finger_top_jnt_1", "r_finger_end_jnt_1", "right_middledistal" } },
        { HumanBodyBones.RightRingProximal, new List<string> { "right_ring_1", "ring1_r", "r_ring_1", "r_ring1", "ring_01_r", "righthandring1", "ring.01.r", "r_bd_fk_finger_base_jnt_2", "r_finger_middle_jnt_2", "right_ringproximal" } },
        { HumanBodyBones.RightRingIntermediate, new List<string> { "right_ring_2", "ring2_r", "r_ring_2", "r_ring2", "ring_02_r", "righthandring2", "ring.02.r", "r_bd_fk_finger_mid_jnt_2", "r_finger_top_jnt_2", "right_ringintermediate" } },
        { HumanBodyBones.RightRingDistal, new List<string> { "right_ring_3", "ring3_r", "r_ring_3", "r_ring3", "ring_03_r", "righthandring3", "ring.03.r", "r_bd_fk_finger_top_jnt_2", "r_finger_end_jnt_2", "right_ringdistal" } },
        { HumanBodyBones.RightLittleProximal, new List<string> { "right_little_1", "pinky1_r", "r_pinky_1", "r_pinky1", "pinky_01_r", "righthandpinky1", "pinky.01.r", "r_bd_fk_finger_base_jnt_3", "r_finger_middle_jnt_3", "right_pinkyproximal" } },
        { HumanBodyBones.RightLittleIntermediate, new List<string> { "right_little_2", "pinky2_r", "r_pinky_2", "r_pinky2", "pinky_02_r", "righthandpinky2", "pinky.02.r", "r_bd_fk_finger_mid_jnt_3", "r_finger_top_jnt_3", "right_pinkyintermediate" } },
        { HumanBodyBones.RightLittleDistal, new List<string> { "right_little_3", "pinky3_r", "r_pinky_3", "r_pinky3", "pinky_03_r", "righthandpinky3", "pinky.03.r", "r_bd_fk_finger_top_jnt_3", "r_finger_end_jnt_3", "right_pinkydistal" } }
    };

    public static Dictionary<string, BoneTransformData> AccuRig = new Dictionary<string, BoneTransformData>
    {
        {"RL_BoneRoot", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Hip", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.04f, 0.97f), new Quaternion(0.80280f, 0.00084f, -0.00110f, 0.59624f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Pelvis", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.09614f, 0.00000f, 0.00000f, 0.99537f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thigh", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.10f, -0.02f, 0.01f), new Quaternion(0.00071f, 0.24620f, 0.96919f, -0.00717f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Calf", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.44f, 0.00f), new Quaternion(-0.01726f, -0.00346f, 0.00972f, 0.99980f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_CalfTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00249f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_CalfTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.20f, 0.00f), new Quaternion(0.00000f, -0.04145f, 0.00000f, 0.99914f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Foot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.40f, 0.00f), new Quaternion(0.53368f, 0.03219f, -0.02851f, 0.84460f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ToeBase", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.17639f, -0.02530f, 0.01968f, 0.98380f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_BigToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.04f, 0.02f, 0.00f), new Quaternion(-0.06661f, -0.00009f, -0.01396f, 0.99768f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_IndexToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.02f, 0.00f), new Quaternion(-0.23075f, -0.04440f, -0.01254f, 0.97192f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_MidToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.21687f, -0.03765f, -0.00099f, 0.97547f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_PinkyToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, -0.01f), new Quaternion(-0.23774f, -0.03259f, 0.03545f, 0.97013f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_RingToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.01f, 0.00f), new Quaternion(-0.28213f, -0.04969f, 0.01312f, 0.95800f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ToeBaseShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.17638f, -0.02549f, 0.01968f, 0.98380f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_KneeShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00866f, 0.00276f, -0.00491f, 0.99995f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ThighTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00001f, -0.00279f, 0.00006f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ThighTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.22f, 0.00f), new Quaternion(-0.00001f, 0.00279f, -0.00005f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thigh", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.10f, -0.02f, 0.01f), new Quaternion(-0.00042f, 0.24230f, 0.97018f, 0.00593f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Calf", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.44f, 0.00f), new Quaternion(-0.00872f, 0.00181f, -0.00644f, 0.99994f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_CalfTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00007f, 0.00044f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_CalfTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.20f, 0.00f), new Quaternion(0.00007f, 0.03607f, -0.00001f, 0.99935f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Foot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.41f, 0.00f), new Quaternion(0.53417f, -0.03597f, 0.03241f, 0.84399f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ToeBase", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.17660f, 0.02530f, -0.01970f, 0.98376f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_BigToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.04f, 0.02f, 0.00f), new Quaternion(-0.06660f, 0.00009f, 0.01396f, 0.99768f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_IndexToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, 0.02f, 0.00f), new Quaternion(-0.23075f, 0.04440f, 0.01254f, 0.97192f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_MidToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.21710f, 0.03767f, 0.00101f, 0.97542f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_PinkyToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, -0.01f), new Quaternion(-0.23775f, 0.03259f, -0.03545f, 0.97013f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_RingToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.01f, 0.00f), new Quaternion(-0.28211f, 0.04969f, -0.01312f, 0.95800f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ToeBaseShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.17660f, 0.02549f, -0.01967f, 0.98376f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_KneeShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00436f, -0.00069f, 0.00322f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ThighTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00002f, 0.00181f, -0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ThighTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.22f, 0.00f), new Quaternion(0.00000f, -0.00182f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Waist", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.11f, 0.02f), new Quaternion(-0.14574f, 0.00020f, 0.00137f, 0.98932f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Spine01", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(-0.00022f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Spine02", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.07284f, -0.00001f, 0.00000f, 0.99734f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Clavicle", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.05f, 0.21f, -0.01f), new Quaternion(-0.03049f, -0.13353f, 0.69672f, 0.70415f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Upperarm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.11517f, -0.00109f, -0.00389f, 0.99334f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Forearm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.27f, 0.00f), new Quaternion(0.00123f, 0.00178f, 0.00037f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ElbowShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.03167f, -0.01336f, 0.04695f, 0.99831f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ForearmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.03131f, 0.00000f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ForearmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.06237f, 0.00000f, 0.99805f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Hand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.21f, 0.00f), new Quaternion(-0.02029f, 0.00013f, -0.00701f, 0.99977f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index1", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.00f, 0.12f, 0.05f), new Quaternion(0.02242f, 0.00347f, 0.01616f, 0.99961f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index2", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00220f, -0.00525f, 0.00047f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index3", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00111f, 0.00003f, 0.00154f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.00f, 0.12f, 0.02f), new Quaternion(0.02148f, 0.00283f, 0.01643f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid2", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(-0.00198f, -0.00350f, 0.00009f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid3", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00080f, -0.00010f, 0.00064f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky1", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.11f, -0.02f), new Quaternion(0.01643f, -0.00037f, 0.01547f, 0.99975f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky2", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00906f, 0.00142f, -0.00002f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00188f, -0.00012f, 0.02691f, 0.99964f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring1", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.00f, 0.11f, 0.00f), new Quaternion(0.01255f, -0.00058f, 0.01484f, 0.99981f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(-0.00429f, 0.00013f, 0.00064f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring3", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00150f, 0.00018f, 0.00281f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb1", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.01f, 0.03f, 0.03f), new Quaternion(0.00818f, 0.69943f, 0.02008f, 0.71437f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb2", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(0.00011f, 0.00170f, -0.00558f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb3", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00537f, -0.00130f, 0.00424f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_UpperarmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00021f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_UpperarmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, -0.00021f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_RibsTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.09f, 0.06f, 0.08f), new Quaternion(-0.00001f, 0.63663f, 0.77117f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Breast", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_NeckTwist01", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.27f, 0.00f), new Quaternion(0.20432f, 0.00002f, 0.00000f, 0.97890f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_NeckTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00001f, 0.00001f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.11761f, -0.00004f, 0.00000f, 0.99306f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_FacialBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.49999f, -0.49999f, -0.50001f, 0.50000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_JawRoot", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.02f, 0.00f), new Quaternion(-0.00005f, 0.00005f, -0.70709f, 0.70712f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Teeth02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.01f, 0.00f), new Quaternion(1.00000f, 0.00000f, -0.00010f, -0.00008f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.01f, 0.00f), new Quaternion(0.00000f, 0.00001f, -0.05349f, 0.99857f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00001f, -0.07747f, 0.99700f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue03", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00012f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Eye", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.07f, 0.08f, 0.03f), new Quaternion(0.70711f, 0.00000f, -0.70711f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Eye", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.07f, 0.08f, -0.03f), new Quaternion(0.70711f, 0.00000f, -0.70711f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_UpperJaw", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.07f, 0.00f), new Quaternion(0.00004f, 0.00004f, -0.70711f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Teeth01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(1.00000f, 0.00001f, 0.00003f, 0.00001f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Clavicle", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.05f, 0.21f, -0.01f), new Quaternion(-0.03049f, 0.13352f, -0.69672f, 0.70415f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Upperarm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.11519f, 0.00109f, 0.00389f, 0.99334f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Forearm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.27f, 0.00f), new Quaternion(0.00123f, -0.00178f, -0.00036f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ElbowShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00794f, -0.01813f, -0.05093f, 0.99851f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ForearmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.01229f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ForearmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.02546f, 0.00000f, 0.99968f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Hand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.20f, 0.00f), new Quaternion(-0.02029f, -0.00013f, 0.00700f, 0.99977f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index1", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.00f, 0.13f, 0.04f), new Quaternion(0.02242f, -0.00347f, -0.01616f, 0.99961f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index2", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00220f, 0.00525f, -0.00045f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index3", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00111f, -0.00003f, -0.00155f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.00f, 0.13f, 0.02f), new Quaternion(0.02148f, -0.00283f, -0.01643f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid2", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.00199f, 0.00350f, -0.00009f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid3", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00080f, 0.00010f, -0.00064f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky1", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, 0.11f, -0.02f), new Quaternion(0.01641f, 0.00037f, -0.01549f, 0.99975f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky2", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00904f, -0.00142f, 0.00000f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00187f, 0.00012f, -0.02692f, 0.99964f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring1", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.01254f, 0.00058f, -0.01479f, 0.99981f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.00425f, -0.00013f, -0.00070f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring3", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00147f, -0.00018f, -0.00279f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb1", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.01f, 0.04f, 0.03f), new Quaternion(0.00818f, -0.69943f, -0.02008f, 0.71437f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb2", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, 0.07f, 0.00f), new Quaternion(0.00013f, -0.00170f, -0.00558f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb3", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00537f, 0.00130f, -0.00424f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_UpperarmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00021f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_UpperarmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, 0.00021f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_RibsTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.09f, 0.06f, 0.08f), new Quaternion(0.00000f, 0.63663f, 0.77117f, 0.00001f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Breast", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> Cinema4DAdvancedBiped = new Dictionary<string, BoneTransformData>
    {
        {"Advanced Biped (Cinema 4D)", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-4.54f, 0.00f, 1.90f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Spine_01_jnt", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.74f, 0.00f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Spine_02_jnt", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Spine_03_jnt", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Spine_04_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Chest_jnt", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, -0.00299f, 1.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Neck_jnt", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.00f, -0.22f), new Quaternion(0.00000f, 0.24176f, 0.97034f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Head_jnt", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.00f, -0.09f), new Quaternion(-0.29677f, 0.00000f, 0.00000f, 0.95495f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"BD_Head_Tip_jnt", new BoneTransformData(HumanBodyBones.RightEye, new Vector3(0.00f, 0.00f, -0.25f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_Collar_jnt", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(0.04f, -0.04f, -0.12f), new Quaternion(-0.42996f, -0.52598f, 0.55871f, 0.47573f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_Collar_Tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.16f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Shoulder_jnt", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.09021f, 0.03433f, -0.70125f, 0.70635f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Forearm_Twist_01_jnt", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.00f, -0.21f), new Quaternion(-0.01519f, 0.01519f, 0.70694f, 0.70694f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Forearm_Twist_02_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.09f), new Quaternion(-0.00004f, -0.03251f, 0.00125f, 0.99947f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Forearm_Twist_05_tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.09f), new Quaternion(0.00000f, 0.00000f, 0.00125f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_Wrist_01_jnt", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00199f, 0.00776f, 0.00016f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_Wrist_02_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00000f, -0.71655f, 0.00000f, 0.69753f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Palm_Base_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00331f, 0.77351f, -0.00023f, 0.63377f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Base_jnt", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00563f, -0.07846f, 0.00045f, 0.99690f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Mid_jnt", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Top_jnt", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, -0.70710f, -0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Palm_Base_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.01f), new Quaternion(-0.00330f, 0.74513f, -0.00038f, 0.66691f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Base_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00565f, -0.03489f, 0.00020f, 0.99938f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Mid_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Top_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_End_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, -0.70710f, -0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Palm_Base_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(-0.00328f, 0.71533f, -0.00052f, 0.69878f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Base_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00565f, 0.00873f, -0.00005f, 0.99995f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Mid_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Top_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_End_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, -0.70710f, -0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Palm_Base_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(-0.00325f, 0.68417f, -0.00066f, 0.72932f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Base_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00367f, 0.05145f, -0.00020f, 0.99867f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Mid_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_Top_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Finger_End_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, -0.70710f, -0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Thumb_Root_jnt", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(0.04f, 0.00f, 0.02f), new Quaternion(-0.00049f, 0.72093f, 0.00192f, 0.69300f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Thumb_Base_jnt", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00232f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Thumb_Mid_jnt", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(-0.01590f, 0.00000f, 0.00000f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_FK_Thumb_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_Collar_jnt", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(-0.04f, -0.04f, -0.12f), new Quaternion(0.42996f, -0.52598f, 0.55871f, -0.47573f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_Collar_Tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.16f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Shoulder_jnt", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.09021f, -0.03433f, 0.70125f, 0.70635f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Forearm_Twist_01_jnt", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.00f, -0.21f), new Quaternion(-0.01519f, -0.01519f, -0.70694f, 0.70694f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Forearm_Twist_02_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.09f), new Quaternion(-0.00004f, 0.03251f, -0.00125f, 0.99947f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Forearm_Twist_05_tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.09f), new Quaternion(0.00000f, 0.00000f, -0.00125f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_Wrist_01_jnt", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00199f, -0.00776f, 0.00019f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_Wrist_02_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00000f, 0.71655f, 0.00000f, 0.69753f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Palm_Base_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00331f, -0.77351f, 0.00023f, 0.63377f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Base_jnt", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00563f, 0.07846f, -0.00045f, 0.99690f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Mid_jnt", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Top_jnt", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, 0.70710f, 0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Palm_Base_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.01f), new Quaternion(-0.00330f, -0.74513f, 0.00038f, 0.66691f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Base_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00565f, 0.03489f, -0.00020f, 0.99938f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Mid_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Top_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_End_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, 0.70710f, 0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Palm_Base_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(-0.00328f, -0.71533f, 0.00052f, 0.69878f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Base_jnt_2", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00565f, -0.00873f, 0.00005f, 0.99995f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Mid_jnt_2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Top_jnt_2", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_End_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, 0.70710f, 0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Palm_Base_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(-0.00325f, -0.68417f, 0.00066f, 0.72932f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Base_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(-0.00366f, -0.05145f, -0.00012f, 0.99867f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Mid_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_Top_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Finger_End_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00399f, 0.70710f, 0.00399f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Thumb_Root_jnt", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(-0.04f, 0.00f, 0.02f), new Quaternion(-0.00049f, -0.72093f, -0.00192f, 0.69300f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Thumb_Base_jnt", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00232f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Thumb_Mid_jnt", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.00f, -0.05f), new Quaternion(-0.01590f, 0.00000f, 0.00000f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_FK_Thumb_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Hip_jnt", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.08f, 0.00f, 0.05f), new Quaternion(0.00270f, 0.99999f, -0.00474f, -0.00020f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Knee_jnt", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.00f, -0.29f), new Quaternion(-0.01174f, 0.00000f, 0.00000f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Ankle_jnt", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.00f, -0.30f), new Quaternion(0.51604f, -0.00102f, -0.00251f, 0.85656f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Ball_jnt", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.00f, -0.16f), new Quaternion(0.23799f, 0.00000f, 0.00000f, 0.97127f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_BD_NB_Toes_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.99984f, 0.01785f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Hip_jnt", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.08f, 0.00f, 0.05f), new Quaternion(-0.00270f, 0.99999f, -0.00475f, 0.00020f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Knee_jnt", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.00f, -0.29f), new Quaternion(-0.01174f, 0.00000f, 0.00000f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Ankle_jnt", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.00f, -0.30f), new Quaternion(0.51605f, 0.00102f, 0.00251f, 0.85656f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Ball_jnt", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.00f, -0.16f), new Quaternion(0.23799f, 0.00000f, 0.00000f, 0.97127f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_BD_NB_Toes_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.99984f, 0.01785f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> UnityHumanoid = new Dictionary<string, BoneTransformData>
    {
        {"Skeleton", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Hips", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.98f, -0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_UpperLeg", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.09f, -0.05f, -0.01f), new Quaternion(1.00000f, -0.00030f, 0.00009f, -0.00261f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_LowerLeg", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.41f, 0.00f), new Quaternion(-0.00085f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_Foot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.41f, 0.00f), new Quaternion(-0.00111f, 0.01416f, -0.00382f, 0.99989f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_Toes", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.07f, -0.12f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_ToesEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.06f, 0.02f), new Quaternion(0.70707f, -0.00763f, -0.00763f, 0.70707f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_UpperLeg", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.09f, -0.05f, -0.01f), new Quaternion(0.00261f, 0.00010f, 0.00030f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_LowerLeg", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, -0.41f, 0.00f), new Quaternion(-0.00085f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_Foot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, -0.41f, 0.00f), new Quaternion(-0.00111f, 0.01416f, -0.00382f, 0.99989f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_Toes", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, -0.07f, 0.12f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_ToesEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.06f, -0.02f), new Quaternion(0.70707f, -0.00763f, -0.00763f, 0.70707f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Chest", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"UpperChest", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_Shoulder", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(0.00f, 0.19f, -0.01f), new Quaternion(-0.00495f, -0.11352f, 0.04328f, 0.99258f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_UpperArm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(-0.17f, 0.00f, 0.00f), new Quaternion(0.08065f, 0.07729f, 0.66917f, 0.73467f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_LowerArm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.29f, 0.00f), new Quaternion(-0.00049f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_Hand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.24f, 0.00f), new Quaternion(0.00035f, -0.00559f, 0.03768f, 0.99927f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_IndexProximal", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.01f, 0.09f, 0.03f), new Quaternion(-0.02726f, -0.70291f, -0.02710f, 0.71024f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_IndexIntermediate", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00202f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_IndexDistal", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00474f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_IndexDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_MiddleProximal", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.01f, 0.09f, 0.00f), new Quaternion(-0.02451f, -0.70481f, -0.02551f, 0.70852f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_MiddleIntermediate", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(-0.00111f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_MiddleDistal", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00730f, 0.00000f, 0.00000f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_MiddleDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_PinkyProximal", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.07f, -0.03f), new Quaternion(-0.01937f, -0.70195f, -0.02460f, 0.71154f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_PinkyIntermediate", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00160f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_PinkyDistal", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00320f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_PinkyDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_RingProximal", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.01f, 0.08f, -0.01f), new Quaternion(-0.02732f, -0.70268f, -0.02697f, 0.71047f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_RingIntermediate", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00879f, 0.00000f, 0.00000f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_RingDistal", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00535f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_RingDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_ThumbProximal", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(0.00f, 0.03f, 0.02f), new Quaternion(0.07328f, 0.72990f, 0.08227f, -0.67462f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_ThumbIntermediate", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.14828f, 0.00016f, -0.00177f, 0.98894f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_ThumbDistal", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.04f, -0.01f), new Quaternion(-0.07863f, 0.00005f, 0.00432f, 0.99689f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_ThumbDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.25f, -0.02f), new Quaternion(0.06069f, 0.00000f, 0.00000f, 0.99816f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.06069f, 0.00000f, 0.00000f, 0.99816f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Jaw", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.01f, 0.01f), new Quaternion(0.15949f, 0.68888f, 0.15949f, 0.68888f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Left_Eye", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.03f, 0.09f), new Quaternion(0.00000f, 0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_Eye", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.03f, 0.09f), new Quaternion(0.70711f, 0.00000f, 0.70711f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck_Twist_A", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_Shoulder", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.00f, 0.19f, -0.01f), new Quaternion(0.99258f, -0.04328f, -0.11352f, 0.00495f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_UpperArm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.17f, 0.00f, 0.00f), new Quaternion(0.08064f, 0.07730f, 0.66917f, 0.73467f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_LowerArm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, -0.29f, 0.00f), new Quaternion(-0.00049f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_Hand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, -0.24f, 0.00f), new Quaternion(0.00035f, -0.00558f, 0.03768f, 0.99927f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_IndexProximal", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(-0.01f, -0.09f, -0.03f), new Quaternion(-0.02726f, -0.70291f, -0.02710f, 0.71024f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_IndexIntermediate", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, -0.04f, 0.00f), new Quaternion(0.00202f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_IndexDistal", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(0.00474f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_IndexDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_MiddleProximal", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(-0.01f, -0.09f, 0.00f), new Quaternion(-0.02451f, -0.70481f, -0.02551f, 0.70852f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_MiddleIntermediate", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, -0.05f, 0.00f), new Quaternion(-0.00111f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_MiddleDistal", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(0.00730f, 0.00000f, 0.00000f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_MiddleDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_PinkyProximal", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, -0.07f, 0.03f), new Quaternion(-0.01938f, -0.70194f, -0.02460f, 0.71154f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_PinkyIntermediate", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(-0.00160f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_PinkyDistal", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.00320f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_PinkyDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_RingProximal", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(-0.01f, -0.08f, 0.01f), new Quaternion(-0.02732f, -0.70268f, -0.02697f, 0.71047f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_RingIntermediate", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, -0.04f, 0.00f), new Quaternion(0.00880f, 0.00000f, 0.00000f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_RingDistal", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(-0.00535f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_RingDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_ThumbProximal", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.00f, -0.03f, -0.02f), new Quaternion(-0.07327f, -0.72990f, -0.08227f, 0.67462f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_ThumbIntermediate", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(0.14828f, 0.00016f, -0.00177f, 0.98894f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_ThumbDistal", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, -0.04f, 0.01f), new Quaternion(-0.07862f, 0.00005f, 0.00432f, 0.99689f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Right_ThumbDistalEnd", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> Cinema4DBiped = new Dictionary<string, BoneTransformData>
    {
        {"Biped (Cinema 4D)", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-6.83f, 0.00f, 1.86f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Root_null_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.78f, -0.02f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine_FK_null", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Hip_FK_00_jnt", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Midd_FK_01_jnt", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.00f, -0.15f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Chest_FK_01_jnt", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.00f, -0.15f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Arm_null", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.00f, -0.16f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Collar_jnt", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00556f, 0.64767f, -0.00834f, 0.76186f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Shoulder_jnt", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.00f, -0.13f), new Quaternion(-0.00611f, 0.08284f, 0.01253f, 0.99647f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Elbow_jnt", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.00f, -0.22f), new Quaternion(0.00114f, 0.00161f, 0.00749f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Hand_jnt", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.00f, -0.23f), new Quaternion(0.02644f, 0.00038f, 0.00000f, 0.99965f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_FK_Hand_con_", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.02508f, -0.00023f, -0.01006f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Base_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00655f, 0.06543f, -0.00483f, 0.99782f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Middle_jnt", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, -0.06105f, 0.00000f, 0.99813f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Top_jnt", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_End_jnt", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Base_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00633f, 0.02185f, -0.00511f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Middle_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, -0.02618f, 0.00000f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Top_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_End_jnt_1", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Tip_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Base_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.00f, 0.00f), new Quaternion(-0.00611f, -0.02178f, -0.00538f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Middle_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, 0.01745f, 0.00000f, 0.99985f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Top_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_End_jnt_2", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Tip_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Base_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, 0.00f, 0.00f), new Quaternion(-0.00586f, -0.06537f, -0.00564f, 0.99783f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Middle_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00053f, 0.06104f, 0.00871f, 0.99810f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Top_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_End_jnt_3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Finger_Tip_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, -0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Thumb_Base_jnt", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.03f, -0.01f, 0.00f), new Quaternion(0.00203f, -0.00538f, 0.00271f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Thumb_Middle_jnt", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Thumb_Top_jnt", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Thumb_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(0.00000f, -0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck_FK_02_jnt", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.00f, -0.16f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head_00_jnt", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.00f, -0.12f), new Quaternion(0.00000f, -0.00945f, 0.99996f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head_01_jnt", new BoneTransformData(HumanBodyBones.LeftEye, new Vector3(0.00f, 0.00f, -0.18f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spinetip_FK_03_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.12f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Arm_null", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.00f, -0.16f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Collar_jnt", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00556f, -0.64767f, 0.00834f, 0.76186f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Shoulder_jnt", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.00f, -0.13f), new Quaternion(-0.00611f, -0.08284f, -0.01253f, 0.99647f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Elbow_jnt", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.00f, -0.22f), new Quaternion(0.00114f, -0.00161f, -0.00757f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Hand_jnt", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.00f, -0.23f), new Quaternion(0.02644f, -0.00038f, 0.00000f, 0.99965f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_FK_Hand_con_", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.02508f, 0.00023f, 0.01006f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Base_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, 0.00f, 0.00f), new Quaternion(-0.00655f, -0.06543f, 0.00483f, 0.99782f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Middle_jnt", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, 0.06105f, 0.00000f, 0.99813f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Top_jnt", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_End_jnt", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Tip_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Base_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00633f, -0.02185f, 0.00511f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Middle_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, 0.02618f, 0.00000f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Top_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_End_jnt_1", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Tip_jnt_1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Base_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.00f, 0.00f), new Quaternion(-0.00611f, 0.02178f, 0.00538f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Middle_jnt_2", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00000f, -0.01745f, 0.00000f, 0.99985f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Top_jnt_2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_End_jnt_2", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Tip_jnt_2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Base_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00586f, 0.06537f, 0.00564f, 0.99783f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Middle_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, 0.00f, -0.07f), new Quaternion(0.00053f, -0.06105f, -0.00871f, 0.99810f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Top_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_End_jnt_3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Finger_Tip_jnt_3", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(0.00000f, 0.70711f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Thumb_Base_jnt", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.03f, -0.01f, 0.00f), new Quaternion(0.00203f, 0.00538f, -0.00272f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Thumb_Middle_jnt", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Thumb_Top_jnt", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Thumb_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(0.00000f, 0.01265f, 0.00000f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Hip_jnt", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.10f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.70935f, 0.70485f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Knee_jnt", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.00f, -0.36f), new Quaternion(-0.00660f, 0.00000f, 0.00000f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Foot_jnt", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.00f, -0.37f), new Quaternion(0.52480f, 0.00000f, 0.00000f, 0.85122f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Toe_jnt", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.23415f, 0.00000f, 0.00000f, 0.97220f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"L_Toe_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Hip_jnt", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.10f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.70935f, 0.70485f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Knee_jnt", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.00f, -0.36f), new Quaternion(-0.00660f, 0.00000f, 0.00000f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Foot_jnt", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.00f, -0.37f), new Quaternion(0.52480f, 0.00000f, 0.00000f, 0.85123f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Toe_jnt", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.23415f, 0.00000f, 0.00000f, 0.97220f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"R_Toe_End_jnt", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.10f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> CharacterCreator4 = new Dictionary<string, BoneTransformData>
    {
        {"CC3_Plus (Character Creator 4)", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-3.92f, 0.00f, 2.27f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Body", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_BoneRoot", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.03f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Hip", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.00f, 1.01f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Pelvis", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.09792f, 0.00000f, 0.00000f, 0.99519f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thigh", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.09f, -0.02f, 0.00f), new Quaternion(0.00102f, 0.10213f, 0.99471f, -0.01071f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Calf", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.46f, 0.00f), new Quaternion(-0.01286f, -0.00016f, -0.00139f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_CalfTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00001f, 0.00000f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_CalfTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.24f, 0.00f), new Quaternion(0.00000f, -0.00052f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Foot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.47f, 0.00f), new Quaternion(0.61079f, 0.03881f, -0.03789f, 0.78993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ToeBase", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(0.17881f, -0.02663f, 0.02902f, 0.98309f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_BigToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.04f, 0.02f, 0.00f), new Quaternion(-0.03183f, -0.00001f, -0.01052f, 0.99944f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_IndexToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.02f, 0.00f), new Quaternion(-0.16306f, -0.04251f, -0.01295f, 0.98561f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_MidToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.15287f, -0.03774f, -0.01258f, 0.98744f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_PinkyToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, -0.01f), new Quaternion(-0.19037f, -0.03144f, 0.01727f, 0.98106f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_RingToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.01f, 0.00f), new Quaternion(-0.22508f, -0.04950f, -0.00195f, 0.97308f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ToeBaseShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(0.17882f, -0.02681f, 0.02900f, 0.98309f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_KneeShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00014f, -0.01608f, 0.00000f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ThighTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00002f, 0.00000f, -0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ThighTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.23f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thigh", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.09f, -0.02f, 0.00f), new Quaternion(-0.00102f, 0.10213f, 0.99471f, 0.01070f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Calf", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.46f, 0.00f), new Quaternion(-0.01278f, 0.00016f, 0.00139f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_CalfTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00001f, 0.00000f, -0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_CalfTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.24f, 0.00f), new Quaternion(0.00000f, 0.00052f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Foot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.47f, 0.00f), new Quaternion(0.61073f, -0.03881f, 0.03789f, 0.78998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ToeBase", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(0.17881f, 0.02663f, -0.02902f, 0.98309f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_BigToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.04f, 0.02f, 0.00f), new Quaternion(-0.03183f, 0.00001f, 0.01052f, 0.99944f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_IndexToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.02f, 0.00f), new Quaternion(-0.16306f, 0.04251f, 0.01295f, 0.98561f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_MidToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.15287f, 0.03774f, 0.01258f, 0.98744f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_PinkyToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, -0.01f), new Quaternion(-0.19037f, 0.03144f, -0.01727f, 0.98106f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_RingToe1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.01f, 0.00f), new Quaternion(-0.22508f, 0.04950f, 0.00195f, 0.97308f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ToeBaseShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(0.17882f, 0.02681f, -0.02900f, 0.98309f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_KneeShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00011f, 0.01608f, 0.00000f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ThighTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00002f, 0.00000f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ThighTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.23f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Waist", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.08f, 0.02f), new Quaternion(0.12068f, 0.00000f, 0.00000f, 0.99269f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Spine01", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.15604f, 0.00000f, 0.00000f, 0.98775f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Spine02", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(-0.05831f, 0.00000f, 0.00000f, 0.99830f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Clavicle", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.05f, 0.21f, 0.00f), new Quaternion(-0.01052f, -0.14422f, 0.69461f, 0.70471f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Upperarm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.10858f, 0.00137f, -0.00383f, 0.99408f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Forearm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.26f, 0.00f), new Quaternion(0.00009f, -0.00003f, 0.00268f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ElbowShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00340f, -0.00042f, 0.00055f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ForearmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_ForearmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Hand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.25f, 0.00f), new Quaternion(-0.01711f, -0.00007f, -0.01008f, 0.99980f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index1", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.00f, 0.09f, 0.04f), new Quaternion(0.01529f, 0.00454f, 0.01156f, 0.99981f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index2", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.01025f, -0.00598f, 0.00984f, 0.99988f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Index3", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.01739f, 0.00012f, -0.03270f, 0.99931f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.00f, 0.09f, 0.02f), new Quaternion(0.01962f, 0.00381f, 0.01196f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid2", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00094f, -0.00383f, 0.00599f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Mid3", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00984f, -0.00030f, -0.02293f, 0.99969f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky1", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.09f, -0.02f), new Quaternion(0.01278f, 0.00033f, 0.00858f, 0.99988f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky2", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00685f, 0.00199f, 0.01614f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Pinky3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.01f, 0.00f), new Quaternion(0.00160f, -0.00296f, -0.06053f, 0.99816f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring1", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.00f, 0.09f, 0.00f), new Quaternion(0.01351f, 0.00047f, 0.00625f, 0.99989f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.00737f, -0.00097f, 0.03044f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Ring3", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.00057f, -0.00024f, -0.04670f, 0.99891f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb1", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.01f, 0.02f, 0.02f), new Quaternion(0.00797f, 0.70117f, 0.02473f, 0.71252f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb2", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(0.01844f, 0.01286f, -0.01321f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Thumb3", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00904f, -0.00180f, -0.02446f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_UpperarmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00065f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_UpperarmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, 0.00065f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_RibsTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.10f, 0.06f, 0.09f), new Quaternion(-0.00001f, 0.63757f, 0.77039f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Breast", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_NeckTwist01", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.27f, 0.00f), new Quaternion(0.19802f, 0.00000f, 0.00000f, 0.98020f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_NeckTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.01391f, 0.00000f, 0.00000f, 0.99990f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.11892f, 0.00000f, 0.00000f, 0.99290f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_FacialBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.50000f, -0.50000f, -0.50000f, 0.50000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_JawRoot", new BoneTransformData(HumanBodyBones.Jaw, new Vector3(-0.01f, 0.02f, 0.00f), new Quaternion(-0.00006f, 0.00004f, -0.70709f, 0.70712f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Teeth02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.01f, 0.00f), new Quaternion(1.00000f, 0.00000f, -0.00010f, -0.00008f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.01f, 0.00f), new Quaternion(0.00000f, 0.00002f, -0.05436f, 0.99852f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00001f, -0.08161f, 0.99666f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue03", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_L_Eye", new BoneTransformData(HumanBodyBones.LeftEye, new Vector3(-0.07f, 0.07f, 0.03f), new Quaternion(0.70711f, 0.00000f, -0.70711f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Eye", new BoneTransformData(HumanBodyBones.RightEye, new Vector3(-0.07f, 0.07f, -0.03f), new Quaternion(0.70711f, 0.00000f, -0.70711f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_UpperJaw", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.06f, 0.00f), new Quaternion(0.00003f, 0.00003f, -0.70711f, 0.70710f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Teeth01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(1.00000f, 0.00001f, 0.00003f, 0.00001f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Clavicle", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.05f, 0.21f, 0.00f), new Quaternion(-0.01052f, 0.14422f, -0.69461f, 0.70471f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Upperarm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.10858f, -0.00137f, 0.00383f, 0.99408f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Forearm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.26f, 0.00f), new Quaternion(0.00009f, 0.00003f, -0.00268f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ElbowShareBone", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00340f, 0.00042f, -0.00055f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ForearmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_ForearmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Hand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.25f, 0.00f), new Quaternion(-0.01711f, 0.00007f, 0.01008f, 0.99980f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index1", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.00f, 0.09f, 0.04f), new Quaternion(0.01529f, -0.00454f, -0.01156f, 0.99981f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index2", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.01025f, 0.00598f, -0.00984f, 0.99988f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Index3", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.01739f, -0.00012f, 0.03270f, 0.99931f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.00f, 0.09f, 0.02f), new Quaternion(0.01962f, -0.00381f, -0.01196f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid2", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(0.00094f, 0.00383f, -0.00599f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Mid3", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00984f, 0.00030f, 0.02293f, 0.99969f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky1", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, 0.09f, -0.02f), new Quaternion(0.01278f, -0.00033f, -0.00858f, 0.99988f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky2", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00685f, -0.00199f, -0.01614f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Pinky3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.01f, 0.00f), new Quaternion(0.00160f, 0.00296f, 0.06053f, 0.99816f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring1", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.00f, 0.09f, 0.00f), new Quaternion(0.01351f, -0.00047f, -0.00625f, 0.99989f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.04f, 0.00f), new Quaternion(-0.00737f, 0.00097f, -0.03044f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Ring3", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(-0.00057f, 0.00024f, 0.04670f, 0.99891f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb1", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.01f, 0.02f, 0.02f), new Quaternion(0.00797f, -0.70117f, -0.02473f, 0.71252f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb2", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(0.01845f, -0.01287f, 0.01323f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Thumb3", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00904f, 0.00180f, 0.02446f, 0.99966f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_UpperarmTwist01", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00065f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_UpperarmTwist02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, -0.00065f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_RibsTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.10f, 0.06f, 0.09f), new Quaternion(-0.00001f, 0.63757f, 0.77039f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_R_Breast", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Eye", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_EyeOcclusion", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_TearLine", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Teeth", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"CC_Base_Tongue", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> HumanIK = new Dictionary<string, BoneTransformData>
    {
        {"Hips", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 1.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftUpLeg", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.09f, -0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftUpLegRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.04f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftUpLegRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.22f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftLeg", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, -0.45f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftLegRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.18f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftLegRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.37f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftFoot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, -0.41f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftToeBase", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, -0.06f, 0.13f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightUpLeg", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.09f, -0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightUpLegRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.04f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightUpLegRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.22f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightLeg", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, -0.45f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightLegRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.18f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightLegRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.37f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightFoot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, -0.41f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightToeBase", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, -0.06f, 0.13f), new Quaternion(0.00000f, -0.00004f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.07f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine1", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine2", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftShoulder", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.07f, 0.14f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftArm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(-0.11f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00001f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftArmRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00006f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftArmRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.14f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00006f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftForeArm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(-0.27f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00008f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftForeArmRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.12f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00038f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafLeftForeArmRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.24f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00038f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(-0.27f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00042f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftInHandIndex", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00003f, -0.00141f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex1", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(-0.09f, 0.00f, 0.03f), new Quaternion(0.00000f, 0.00031f, 0.00318f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex2", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(-0.00009f, -0.01885f, -0.00508f, 0.99981f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex3", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(-0.00076f, 0.19447f, 0.00590f, 0.98089f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, -0.01f), new Quaternion(-0.00229f, -0.82287f, -0.00446f, 0.56820f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftInHandMiddle", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00003f, -0.00141f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(-0.09f, 0.00f, 0.01f), new Quaternion(0.00000f, 0.00031f, 0.00318f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle2", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00143f, -0.00508f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle3", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(-0.00001f, 0.00407f, 0.00593f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00001f, -0.00824f, -0.00508f, 0.99995f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftInHandPinky", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00003f, -0.00141f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky1", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(-0.09f, 0.00f, -0.02f), new Quaternion(0.00000f, 0.00031f, 0.00318f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky2", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00140f, -0.00508f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00001f, 0.00373f, 0.00586f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00001f, -0.00653f, -0.00472f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftInHandRing", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00003f, -0.00141f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing1", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(-0.09f, 0.00f, -0.01f), new Quaternion(0.00000f, 0.00031f, 0.00318f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, -0.00143f, -0.00508f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing3", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00001f, 0.00407f, 0.00593f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(-0.00001f, -0.00824f, -0.00508f, 0.99995f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftInHandThumb", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00141f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb1", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.04f, -0.01f, 0.04f), new Quaternion(0.01375f, -0.13214f, -0.10047f, 0.98603f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb2", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(-0.03f, -0.01f, 0.01f), new Quaternion(-0.01495f, 0.13407f, 0.09297f, 0.98649f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb3", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00593f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00505f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightShoulder", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.07f, 0.14f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightArm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.11f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00002f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightArmRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00018f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightArmRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.14f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00018f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightForeArm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.27f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00024f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightForeArmRoll1", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.12f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00121f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeafRightForeArmRoll2", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.24f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00121f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.27f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00134f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightInHandIndex", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00008f, -0.01745f, 0.00445f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex1", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.09f, 0.00f, 0.03f), new Quaternion(0.00084f, 0.17365f, -0.00996f, 0.98476f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex2", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.04f, 0.00f, 0.01f), new Quaternion(0.00417f, -0.71930f, 0.01464f, 0.69453f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex3", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.01f, 0.00f, -0.03f), new Quaternion(-0.00766f, -0.75454f, 0.00866f, 0.65615f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00245f, 0.99620f, -0.00337f, -0.08697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightInHandMiddle", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00008f, -0.01745f, 0.00445f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.09f, 0.00f, 0.01f), new Quaternion(0.00084f, 0.17365f, -0.00996f, 0.98476f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle2", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.05f, 0.00f, 0.01f), new Quaternion(0.00417f, -0.71930f, 0.01464f, 0.69453f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle3", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.01f, 0.00f, -0.03f), new Quaternion(-0.00766f, -0.75454f, 0.00866f, 0.65615f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00245f, 0.99620f, -0.00337f, -0.08697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightInHandPinky", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00008f, -0.01745f, 0.00445f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky1", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.09f, 0.00f, -0.03f), new Quaternion(0.00084f, 0.17365f, -0.00996f, 0.98476f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky2", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.03f, 0.00f, 0.01f), new Quaternion(0.00416f, -0.71930f, 0.01464f, 0.69453f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.00f, -0.02f), new Quaternion(-0.00761f, -0.75454f, 0.00865f, 0.65615f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00252f, 0.99620f, -0.00353f, -0.08697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightInHandRing", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00008f, -0.01745f, 0.00445f, 0.99984f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing1", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.09f, 0.00f, -0.01f), new Quaternion(0.00084f, 0.17365f, -0.00996f, 0.98476f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.04f, 0.00f, 0.01f), new Quaternion(0.00417f, -0.71930f, 0.01464f, 0.69453f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing3", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.01f, 0.00f, -0.02f), new Quaternion(-0.00766f, -0.75454f, 0.00866f, 0.65615f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00245f, 0.99620f, -0.00337f, -0.08697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightInHandThumb", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00445f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb1", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.04f, -0.01f, 0.04f), new Quaternion(0.06687f, 0.12653f, 0.09320f, 0.98531f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb2", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.03f, -0.01f, 0.01f), new Quaternion(-0.01363f, -0.11236f, -0.08761f, 0.98970f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb3", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.01870f, 0.99983f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.01608f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> Mixamo = new Dictionary<string, BoneTransformData>
    {
        {"Hips", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.93f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00006f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftUpLeg", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.10f, -0.06f, 0.00f), new Quaternion(0.00042f, -0.01454f, 0.99987f, 0.00762f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftLeg", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.42f, 0.00f), new Quaternion(-0.00094f, 0.00006f, 0.01652f, 0.99986f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftFoot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.36f, 0.00f), new Quaternion(0.46444f, 0.04153f, -0.03117f, 0.88408f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftToeBase", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.30604f, 0.00957f, -0.00308f, 0.95197f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftToe_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightUpLeg", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.10f, -0.06f, 0.00f), new Quaternion(-0.00037f, -0.00847f, 0.99994f, -0.00749f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightLeg", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.42f, 0.00f), new Quaternion(-0.01599f, 0.00008f, -0.01652f, 0.99974f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightFoot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.36f, 0.00f), new Quaternion(0.48103f, -0.03912f, 0.03058f, 0.87530f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightToeBase", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.29671f, -0.01299f, 0.00404f, 0.95487f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightToe_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(-0.01595f, 0.00000f, -0.00006f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine1", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine2", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.14f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftShoulder", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.05f, 0.14f, 0.00f), new Quaternion(0.57396f, -0.41005f, 0.58220f, 0.40433f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftArm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(-0.17093f, -0.00745f, -0.00591f, 0.98524f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftForeArm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.25f, 0.00f), new Quaternion(0.00000f, 0.00248f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.23f, 0.00f), new Quaternion(0.01247f, -0.03717f, 0.05297f, 0.99783f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex1", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.03f, 0.10f, 0.00f), new Quaternion(-0.01477f, -0.00679f, -0.05388f, 0.99842f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex2", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00006f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex3", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00016f, 0.00533f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.01f, 0.10f, 0.00f), new Quaternion(-0.01441f, 0.00036f, -0.05460f, 0.99840f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle2", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00001f, 0.00019f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle3", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00025f, 0.00693f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky1", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(-0.03f, 0.09f, 0.00f), new Quaternion(-0.01484f, -0.00781f, -0.05272f, 0.99847f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky2", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00008f, -0.00225f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, -0.00005f, 0.00605f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing1", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(-0.01f, 0.10f, 0.00f), new Quaternion(-0.01454f, -0.00209f, -0.05136f, 0.99857f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00004f, -0.00328f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing3", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00003f, 0.00352f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb1", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(0.03f, 0.03f, 0.02f), new Quaternion(0.07513f, 0.81603f, -0.01314f, 0.57295f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb2", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00002f, 0.00080f, -0.06935f, 0.99759f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb3", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00045f, 0.00698f, -0.02128f, 0.99975f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.16f, 0.00f), new Quaternion(0.01595f, 0.00000f, 0.00000f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.06f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"HeadTop_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.22f, 0.06f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightShoulder", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.05f, 0.14f, 0.00f), new Quaternion(-0.57560f, -0.40889f, 0.58065f, -0.40538f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightArm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(-0.17101f, 0.00799f, 0.00303f, 0.98523f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightForeArm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.25f, 0.00f), new Quaternion(0.00000f, -0.00240f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.23f, 0.00f), new Quaternion(0.00918f, 0.03116f, -0.05177f, 0.99813f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex1", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(-0.03f, 0.09f, 0.00f), new Quaternion(-0.01109f, 0.00567f, 0.05062f, 0.99864f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex2", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00098f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex3", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00001f, 0.00057f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(-0.01f, 0.10f, 0.00f), new Quaternion(-0.01077f, -0.00044f, 0.05241f, 0.99857f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle2", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00009f, 0.00183f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle3", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00015f, -0.00718f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky1", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.03f, 0.09f, 0.00f), new Quaternion(-0.01100f, 0.00417f, 0.05160f, 0.99860f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky2", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, 0.00001f, 0.00086f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00001f, -0.00257f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing1", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.01f, 0.10f, 0.00f), new Quaternion(-0.01109f, 0.00544f, 0.04826f, 0.99876f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00006f, 0.00534f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing3", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00000f, -0.00004f, -0.00090f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb1", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(-0.03f, 0.03f, 0.02f), new Quaternion(0.07513f, -0.81603f, 0.01314f, 0.57295f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb2", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(0.00002f, -0.00072f, 0.07698f, 0.99703f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb3", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.03f, 0.00f), new Quaternion(-0.00012f, -0.00168f, 0.03009f, 0.99955f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> ReadyPlayerMe = new Dictionary<string, BoneTransformData>
    {
        {"Masculine_XR (Ready Player Me)", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-7.52f, 0.00f, 0.97f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Armature", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Hips", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, -0.01f, 1.02f), new Quaternion(0.71849f, 0.00002f, 0.00002f, 0.69554f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftUpLeg", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(-0.10f, 0.01f, 0.00f), new Quaternion(0.00111f, 0.00966f, 0.99995f, -0.00001f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftLeg", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.00f, 0.46f, 0.00f), new Quaternion(0.00197f, 0.00043f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftFoot", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.00f, 0.44f, 0.00f), new Quaternion(0.48485f, -0.01186f, 0.00658f, 0.87449f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftToeBase", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.26796f, 0.04541f, -0.01264f, 0.96228f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftToe_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00691f, -0.69842f, -0.01767f, 0.71544f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightUpLeg", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.10f, 0.01f, 0.00f), new Quaternion(-0.00116f, 0.00966f, 0.99995f, 0.00001f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightLeg", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(0.00f, 0.46f, 0.00f), new Quaternion(0.00196f, -0.00043f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightFoot", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(0.00f, 0.44f, 0.00f), new Quaternion(0.48486f, 0.01186f, -0.00658f, 0.87449f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightToeBase", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(0.00f, 0.15f, 0.00f), new Quaternion(0.26796f, -0.04538f, 0.01265f, 0.96228f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightToe_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(0.00691f, 0.69843f, 0.01767f, 0.71543f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine", new BoneTransformData(HumanBodyBones.Spine, new Vector3(0.00f, 0.10f, 0.00f), new Quaternion(-0.06869f, -0.00003f, 0.00000f, 0.99764f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine1", new BoneTransformData(HumanBodyBones.Chest, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.03217f, 0.00000f, 0.00000f, 0.99948f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Spine2", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.04720f, 0.00000f, 0.00000f, 0.99889f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftShoulder", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.05f, 0.14f, -0.01f), new Quaternion(0.47085f, -0.56125f, 0.43453f, 0.52390f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftArm", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.09027f, 0.06729f, 0.00277f, 0.99364f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftArmTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.16f, 0.00f), new Quaternion(0.00000f, -0.11481f, 0.00000f, 0.99339f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftForeArm", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.00042f, 0.11465f, -0.00059f, 0.99341f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftForeArmTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.00000f, -0.12286f, 0.00000f, 0.99242f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHand", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.70628f, 0.04205f, 0.03706f, 0.70571f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, -0.01f, 0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex1", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(0.00f, 0.00f, 0.06f), new Quaternion(0.00679f, 0.00152f, -0.00110f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex2", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00047f, -0.00715f, -0.00059f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex3", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(-0.01164f, -0.00887f, 0.00728f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.01f, 0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle1", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(0.00f, 0.01f, 0.06f), new Quaternion(-0.00103f, -0.00464f, -0.00140f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle2", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00515f, 0.00443f, -0.00573f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle3", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00605f, -0.00109f, 0.00559f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, -0.01f, 0.03f), new Quaternion(0.01833f, -0.14034f, 0.20704f, 0.96804f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky1", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(-0.01170f, 0.13239f, -0.20865f, 0.96892f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky2", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.01092f, 0.00261f, 0.00044f, 0.99994f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky3", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00233f, -0.00379f, 0.00506f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, -0.01f, 0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing1", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(-0.00149f, -0.00215f, -0.00767f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing2", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00149f, -0.00428f, 0.00504f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing3", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00380f, 0.00237f, 0.00313f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb1", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(0.03f, -0.02f, 0.03f), new Quaternion(-0.08608f, 0.01388f, -0.00680f, 0.99617f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb2", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(0.00f, -0.01f, 0.03f), new Quaternion(0.08631f, -0.00964f, 0.01029f, 0.99617f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb3", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(0.02404f, -0.01536f, -0.15902f, 0.98686f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftPalm", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Neck", new BoneTransformData(HumanBodyBones.Neck, new Vector3(0.00f, 0.16f, 0.00f), new Quaternion(0.20307f, 0.00000f, 0.00000f, 0.97916f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Head", new BoneTransformData(HumanBodyBones.Head, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(-0.16268f, 0.00000f, 0.00000f, 0.98668f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"HeadTop_End", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.23f, 0.04f), new Quaternion(-0.00361f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"LeftEye", new BoneTransformData(HumanBodyBones.LeftEye, new Vector3(-0.03f, 0.09f, 0.08f), new Quaternion(-0.00361f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightEye", new BoneTransformData(HumanBodyBones.RightEye, new Vector3(0.03f, 0.09f, 0.08f), new Quaternion(-0.00361f, 0.00000f, 0.00000f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightShoulder", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(0.05f, 0.14f, -0.01f), new Quaternion(0.47085f, 0.56125f, -0.43453f, 0.52391f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightArm", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.09028f, -0.06731f, -0.00278f, 0.99364f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightArmTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.16f, 0.00f), new Quaternion(0.00000f, 0.11483f, 0.00000f, 0.99338f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightForeArm", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.00042f, -0.11467f, 0.00060f, 0.99340f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightForeArmTwist", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.12f, 0.00f), new Quaternion(0.00001f, 0.12289f, 0.00000f, 0.99242f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHand", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.00f, 0.13f, 0.00f), new Quaternion(-0.70746f, -0.04355f, -0.04168f, 0.70417f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, -0.01f, 0.04f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex1", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.00f, 0.00f, 0.06f), new Quaternion(0.00679f, -0.00153f, 0.00110f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex2", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00047f, 0.00715f, 0.00059f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex3", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(-0.01151f, 0.00903f, 0.00708f, 0.99987f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandIndex4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.01f, 0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle1", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.00f, 0.01f, 0.06f), new Quaternion(-0.00103f, 0.00464f, 0.00140f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle2", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00515f, -0.00444f, 0.00573f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle3", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00605f, 0.00109f, -0.00559f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandMiddle4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, -0.01f, 0.03f), new Quaternion(0.01833f, 0.14034f, -0.20703f, 0.96804f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky1", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(-0.01170f, -0.13240f, 0.20865f, 0.96892f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky2", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.01092f, -0.00260f, -0.00044f, 0.99994f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky3", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00233f, 0.00379f, -0.00506f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandPinky4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing0", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.01f, 0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing1", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(-0.00148f, 0.00215f, 0.00767f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing2", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.00f, 0.00f, 0.04f), new Quaternion(0.00150f, 0.00428f, -0.00503f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing3", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(-0.00380f, -0.00237f, -0.00313f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandRing4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb1", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(-0.03f, -0.02f, 0.03f), new Quaternion(-0.08609f, -0.01388f, 0.00680f, 0.99617f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb2", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.00f, -0.01f, 0.03f), new Quaternion(0.08631f, 0.00964f, -0.01028f, 0.99617f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb3", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.00f, 0.00f, 0.03f), new Quaternion(0.02404f, 0.01535f, 0.15902f, 0.98686f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightHandThumb4", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.02f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"RightPalm", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.05f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"Wolf3D_Avatar", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 1.00000f, 0.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> UE4 = new Dictionary<string, BoneTransformData>
    {
        {"ik_foot_root", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_foot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.17f, 0.08f, 0.13f), new Quaternion(0.02053f, 0.71223f, -0.01172f, 0.70155f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_foot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.17f, 0.08f, 0.13f), new Quaternion(0.70155f, 0.01172f, 0.71223f, -0.02053f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_root", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_gun", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.57f, 0.00f, 1.12f), new Quaternion(0.61885f, 0.06954f, -0.38914f, 0.67879f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.78f, -0.70f, 0.44f), new Quaternion(0.68747f, 0.61436f, -0.38723f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pelvis", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, 0.01f, 0.97f), new Quaternion(0.00130f, 0.70711f, 0.00130f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_01", new BoneTransformData(HumanBodyBones.Spine, new Vector3(-0.11f, -0.01f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.06239f, 0.99805f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_02", new BoneTransformData(HumanBodyBones.Chest, new Vector3(-0.19f, 0.04f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.12242f, 0.99248f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_03", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(-0.13f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.02425f, 0.99971f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_l", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.12f, -0.03f, -0.04f), new Quaternion(0.21699f, -0.68302f, -0.10817f, 0.68898f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_l", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(-0.16f, 0.00f, 0.00f), new Quaternion(-0.00067f, -0.00456f, 0.22214f, 0.97500f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_l", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(-0.30f, 0.00f, 0.00f), new Quaternion(-0.00155f, 0.03071f, 0.00633f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"hand_l", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(-0.27f, 0.00f, 0.00f), new Quaternion(-0.67957f, 0.02785f, 0.08775f, 0.72781f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_01_l", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(-0.12f, 0.02f, -0.02f), new Quaternion(-0.01902f, 0.04978f, -0.09632f, 0.99392f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_02_l", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.01228f, 0.00163f, 0.00007f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_03_l", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.01033f, -0.00822f, 0.11759f, 0.99298f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_01_l", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(-0.12f, 0.01f, 0.01f), new Quaternion(-0.01887f, 0.03927f, -0.09200f, 0.99480f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_02_l", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(-0.01925f, -0.00632f, -0.02007f, 0.99959f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_03_l", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.00162f, 0.03887f, 0.13362f, 0.99027f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_01_l", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(-0.10f, 0.02f, 0.05f), new Quaternion(-0.02962f, 0.05038f, -0.08528f, 0.99464f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_02_l", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.01107f, 0.00977f, -0.02810f, 0.99950f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_03_l", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00240f, -0.03390f, 0.02595f, 0.99909f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_01_l", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(-0.12f, 0.02f, 0.03f), new Quaternion(-0.01780f, 0.05340f, -0.08379f, 0.99489f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_02_l", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.00552f, 0.01374f, -0.02897f, 0.99947f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_03_l", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(-0.00112f, -0.02623f, 0.14681f, 0.98882f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_01_l", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.05f, 0.02f, -0.03f), new Quaternion(-0.01720f, 0.04855f, -0.08536f, 0.99502f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_02_l", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(-0.00794f, -0.01650f, 0.02556f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_03_l", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.02145f, -0.00114f, 0.07318f, 0.99709f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.14f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_r", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(-0.12f, -0.03f, 0.04f), new Quaternion(0.68302f, 0.21699f, 0.68898f, 0.10817f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_r", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.16f, 0.00f, 0.00f), new Quaternion(-0.00067f, -0.00455f, 0.22213f, 0.97501f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_r", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.30f, 0.00f, 0.00f), new Quaternion(-0.00154f, 0.03071f, 0.00632f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"hand_r", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.27f, 0.00f, 0.00f), new Quaternion(-0.67957f, 0.02786f, 0.08775f, 0.72781f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_01_r", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.12f, -0.02f, 0.02f), new Quaternion(-0.01902f, 0.04978f, -0.09632f, 0.99392f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_02_r", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.01228f, 0.00163f, 0.00007f, 0.99992f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_03_r", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.01033f, -0.00822f, 0.11759f, 0.99297f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_01_r", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.12f, -0.01f, -0.01f), new Quaternion(-0.01888f, 0.03927f, -0.09200f, 0.99480f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_02_r", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.05f, 0.00f, 0.00f), new Quaternion(-0.01925f, -0.00630f, -0.01931f, 0.99961f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_03_r", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.00162f, 0.03887f, 0.13362f, 0.99027f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_01_r", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.10f, -0.02f, -0.05f), new Quaternion(-0.02962f, 0.05038f, -0.08528f, 0.99464f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_02_r", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.01107f, 0.00977f, -0.02810f, 0.99950f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_03_r", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00242f, -0.03390f, 0.02540f, 0.99910f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_01_r", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.11f, -0.02f, -0.03f), new Quaternion(-0.01779f, 0.05340f, -0.08380f, 0.99489f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_02_r", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.00552f, 0.01373f, -0.02897f, 0.99947f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_03_r", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(-0.00112f, -0.02624f, 0.14680f, 0.98882f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_01_r", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.05f, -0.02f, 0.03f), new Quaternion(-0.01720f, 0.04855f, -0.08535f, 0.99502f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_02_r", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(-0.00794f, -0.01650f, 0.02556f, 0.99951f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_03_r", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.02145f, -0.00114f, 0.07319f, 0.99709f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.14f, 0.00f, 0.00f), new Quaternion(-0.11763f, 0.00000f, 0.00000f, 0.99306f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.00f, 0.00f), new Quaternion(-0.17323f, 0.00000f, 0.00000f, 0.98488f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"neck_01", new BoneTransformData(HumanBodyBones.Neck, new Vector3(-0.17f, 0.00f, 0.00f), new Quaternion(0.00010f, 0.00263f, 0.20371f, 0.97903f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"head", new BoneTransformData(HumanBodyBones.Head, new Vector3(-0.09f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.13354f, 0.99104f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_l", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(0.01f, -0.01f, -0.09f), new Quaternion(0.00488f, 0.00035f, 0.01263f, 0.99991f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_l", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.43f, 0.00f, 0.00f), new Quaternion(0.00207f, 0.00212f, 0.01416f, 0.99990f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.20f, 0.00f, 0.00f), new Quaternion(0.00281f, 0.00193f, 0.00761f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"foot_l", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.40f, 0.00f, 0.00f), new Quaternion(-0.00178f, 0.00285f, -0.02697f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ball_l", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.10f, -0.17f, 0.00f), new Quaternion(0.00008f, -0.00003f, 0.71863f, 0.69539f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.22f, 0.00f, 0.00f), new Quaternion(-0.04744f, -0.00002f, 0.00049f, 0.99887f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_r", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.01f, -0.01f, 0.09f), new Quaternion(0.00047f, 0.00486f, -0.99991f, 0.01263f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_r", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(-0.43f, 0.00f, 0.00f), new Quaternion(0.00206f, 0.00212f, 0.01416f, 0.99990f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.20f, 0.00f, 0.00f), new Quaternion(0.00281f, 0.00193f, 0.00761f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"foot_r", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(-0.40f, 0.00f, 0.00f), new Quaternion(-0.00178f, 0.00285f, -0.02697f, 0.99963f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ball_r", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(-0.10f, 0.17f, 0.00f), new Quaternion(0.00008f, -0.00003f, 0.71863f, 0.69539f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.22f, 0.00f, 0.00f), new Quaternion(-0.04745f, -0.00002f, 0.00049f, 0.99887f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
    public static Dictionary<string, BoneTransformData> UE5 = new Dictionary<string, BoneTransformData>
    {
        {"center_of_mass", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_foot_root", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_foot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.14f, 0.01f, 0.08f), new Quaternion(0.06363f, 0.70425f, -0.04138f, 0.70589f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_foot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.14f, 0.01f, 0.08f), new Quaternion(0.70589f, 0.04138f, 0.70425f, -0.06363f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_root", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_gun", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.48f, -0.16f, 1.04f), new Quaternion(0.59846f, 0.00965f, -0.52060f, 0.60887f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.44f, -0.62f, 0.58f), new Quaternion(0.45777f, 0.64551f, -0.61137f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ik_hand_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"interaction", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pelvis", new BoneTransformData(HumanBodyBones.Hips, new Vector3(0.00f, -0.02f, 0.96f), new Quaternion(-0.02241f, 0.70675f, -0.02241f, 0.70675f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_01", new BoneTransformData(HumanBodyBones.Spine, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.12583f, 0.99205f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_02", new BoneTransformData(HumanBodyBones.Chest, new Vector3(-0.07f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.03023f, 0.99954f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_03", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.07f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.09538f, 0.99544f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_04", new BoneTransformData(HumanBodyBones.UpperChest, new Vector3(-0.09f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.05118f, 0.99869f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_05", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.19f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00595f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_l", new BoneTransformData(HumanBodyBones.LeftShoulder, new Vector3(-0.06f, 0.01f, -0.01f), new Quaternion(0.07851f, -0.68252f, 0.04977f, 0.72493f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_out_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.12f, 0.00f, 0.06f), new Quaternion(-0.00259f, 0.02706f, 0.03747f, 0.99893f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_scap_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.10f, 0.08f, -0.02f), new Quaternion(0.02706f, 0.00259f, 0.99893f, -0.03747f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_l", new BoneTransformData(HumanBodyBones.LeftUpperArm, new Vector3(-0.18f, 0.00f, 0.00f), new Quaternion(-0.02606f, -0.01870f, 0.01125f, 0.99942f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_l", new BoneTransformData(HumanBodyBones.LeftLowerArm, new Vector3(-0.28f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00854f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"hand_l", new BoneTransformData(HumanBodyBones.LeftHand, new Vector3(-0.27f, 0.00f, 0.00f), new Quaternion(-0.68079f, -0.01123f, -0.00869f, 0.73234f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_metacarpal_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, -0.02f), new Quaternion(0.02897f, -0.06370f, 0.00711f, 0.99752f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_01_l", new BoneTransformData(HumanBodyBones.LeftIndexProximal, new Vector3(-0.06f, 0.00f, 0.00f), new Quaternion(-0.03519f, 0.06888f, -0.00426f, 0.99699f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_02_l", new BoneTransformData(HumanBodyBones.LeftIndexIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00779f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_03_l", new BoneTransformData(HumanBodyBones.LeftIndexDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.06526f, 0.99787f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_metacarpal_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, -0.01f, 0.00f), new Quaternion(-0.03729f, 0.00039f, 0.02026f, 0.99910f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_01_l", new BoneTransformData(HumanBodyBones.LeftMiddleProximal, new Vector3(-0.06f, 0.00f, 0.00f), new Quaternion(0.03483f, -0.00230f, -0.03115f, 0.99891f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_02_l", new BoneTransformData(HumanBodyBones.LeftMiddleIntermediate, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.01074f, 0.99994f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_03_l", new BoneTransformData(HumanBodyBones.LeftMiddleDistal, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_metacarpal_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, 0.00f, 0.02f), new Quaternion(-0.21823f, 0.18817f, -0.05829f, 0.95581f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_01_l", new BoneTransformData(HumanBodyBones.LeftLittleProximal, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.22008f, -0.17857f, 0.06227f, 0.95697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_02_l", new BoneTransformData(HumanBodyBones.LeftLittleIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.00005f, 0.00017f, 0.00526f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_03_l", new BoneTransformData(HumanBodyBones.LeftLittleDistal, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.04434f, 0.99902f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_metacarpal_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, -0.01f, 0.01f), new Quaternion(-0.11660f, 0.10057f, 0.02566f, 0.98774f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_01_l", new BoneTransformData(HumanBodyBones.LeftRingProximal, new Vector3(-0.06f, 0.00f, 0.00f), new Quaternion(0.11235f, -0.09889f, -0.04615f, 0.98766f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_02_l", new BoneTransformData(HumanBodyBones.LeftRingIntermediate, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00904f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_03_l", new BoneTransformData(HumanBodyBones.LeftRingDistal, new Vector3(-0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.07700f, 0.99703f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_01_l", new BoneTransformData(HumanBodyBones.LeftThumbProximal, new Vector3(-0.02f, 0.01f, -0.03f), new Quaternion(0.00101f, -0.00555f, -0.00264f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_02_l", new BoneTransformData(HumanBodyBones.LeftThumbIntermediate, new Vector3(-0.04f, 0.00f, 0.00f), new Quaternion(0.03502f, 0.00249f, 0.02350f, 0.99911f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_03_l", new BoneTransformData(HumanBodyBones.LeftThumbDistal, new Vector3(-0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.05234f, 0.99863f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"weapon_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.01f, 0.01f), new Quaternion(-0.08981f, 0.14388f, -0.05929f, 0.98373f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"wrist_inner_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.02f, 0.00f), new Quaternion(-0.71632f, -0.08078f, -0.11610f, 0.68329f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"wrist_outer_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.02f, 0.00f), new Quaternion(0.68329f, -0.11610f, 0.08078f, 0.71632f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_correctiveRoot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.01175f, 0.01521f, -0.00018f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_bck_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.05f, -0.01f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_fwd_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, -0.04f, 0.00f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_in_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.01f, -0.04f), new Quaternion(1.00000f, 0.00000f, 0.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_out_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.01f, 0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.18f, 0.00f, 0.00f), new Quaternion(0.01148f, 0.01488f, -0.01749f, 0.99967f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.09f, 0.00f, 0.00f), new Quaternion(0.01148f, 0.01488f, -0.01749f, 0.99967f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_correctiveRoot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_bck_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.08f, 0.00f), new Quaternion(-0.58311f, 0.00000f, 0.00000f, 0.81240f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_fwd_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.03f, -0.09f, -0.01f), new Quaternion(0.75705f, -0.06762f, -0.08010f, 0.64489f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_in_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.06f, -0.01f, -0.05f), new Quaternion(0.91286f, 0.00000f, -0.40828f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_out_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.06f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.09f, 0.00f, 0.00f), new Quaternion(-0.00005f, 0.01879f, 0.00285f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twistCor_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00005f, 0.01879f, 0.00285f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.19f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_bicep_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, -0.04f, -0.02f), new Quaternion(0.67587f, -0.00239f, -0.00809f, 0.73698f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_tricep_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.05f, 0.00f), new Quaternion(-0.73698f, 0.00809f, -0.00239f, 0.67587f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twistCor_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00016f, 0.05634f, 0.00854f, 0.99837f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_pec_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.09f, -0.08f, -0.09f), new Quaternion(0.10851f, -0.72547f, 0.02141f, 0.67931f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_pec_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.09f, -0.08f, 0.10f), new Quaternion(0.72548f, 0.10850f, 0.67930f, -0.02141f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_r", new BoneTransformData(HumanBodyBones.RightShoulder, new Vector3(-0.06f, 0.01f, 0.01f), new Quaternion(0.68252f, 0.07851f, 0.72493f, -0.04977f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_out_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.12f, 0.00f, -0.06f), new Quaternion(-0.00259f, 0.02706f, 0.03747f, 0.99893f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"clavicle_scap_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.10f, -0.08f, 0.02f), new Quaternion(0.02706f, 0.00259f, 0.99893f, -0.03747f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_r", new BoneTransformData(HumanBodyBones.RightUpperArm, new Vector3(0.18f, 0.00f, 0.00f), new Quaternion(-0.02606f, -0.01870f, 0.01125f, 0.99942f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_r", new BoneTransformData(HumanBodyBones.RightLowerArm, new Vector3(0.28f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00854f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"hand_r", new BoneTransformData(HumanBodyBones.RightHand, new Vector3(0.27f, 0.00f, 0.00f), new Quaternion(-0.68079f, -0.01126f, -0.00873f, 0.73234f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_metacarpal_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, 0.02f), new Quaternion(0.02897f, -0.06370f, 0.00711f, 0.99752f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_01_r", new BoneTransformData(HumanBodyBones.RightIndexProximal, new Vector3(0.06f, 0.00f, 0.00f), new Quaternion(-0.03519f, 0.06888f, -0.00426f, 0.99700f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_02_r", new BoneTransformData(HumanBodyBones.RightIndexIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.00779f, 0.99997f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"index_03_r", new BoneTransformData(HumanBodyBones.RightIndexDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.06526f, 0.99787f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_metacarpal_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.01f, 0.00f), new Quaternion(-0.03729f, 0.00039f, 0.02026f, 0.99910f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_01_r", new BoneTransformData(HumanBodyBones.RightMiddleProximal, new Vector3(0.06f, 0.00f, 0.00f), new Quaternion(0.03482f, -0.00230f, -0.03115f, 0.99891f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_02_r", new BoneTransformData(HumanBodyBones.RightMiddleIntermediate, new Vector3(0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.01074f, 0.99994f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"middle_03_r", new BoneTransformData(HumanBodyBones.RightMiddleDistal, new Vector3(0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_metacarpal_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.00f, -0.02f), new Quaternion(-0.21823f, 0.18817f, -0.05829f, 0.95581f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_01_r", new BoneTransformData(HumanBodyBones.RightLittleProximal, new Vector3(0.05f, 0.00f, 0.00f), new Quaternion(0.22008f, -0.17857f, 0.06227f, 0.95697f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_02_r", new BoneTransformData(HumanBodyBones.RightLittleIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.00005f, 0.00017f, 0.00526f, 0.99999f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"pinky_03_r", new BoneTransformData(HumanBodyBones.RightLittleDistal, new Vector3(0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.04362f, 0.99905f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_metacarpal_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.01f, -0.01f), new Quaternion(-0.11660f, 0.10057f, 0.02566f, 0.98774f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_01_r", new BoneTransformData(HumanBodyBones.RightRingProximal, new Vector3(0.06f, 0.00f, 0.00f), new Quaternion(0.11235f, -0.09889f, -0.04615f, 0.98766f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_02_r", new BoneTransformData(HumanBodyBones.RightRingIntermediate, new Vector3(0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00904f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ring_03_r", new BoneTransformData(HumanBodyBones.RightRingDistal, new Vector3(0.02f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.07701f, 0.99703f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_01_r", new BoneTransformData(HumanBodyBones.RightThumbProximal, new Vector3(0.02f, -0.01f, 0.03f), new Quaternion(0.00101f, -0.00555f, -0.00264f, 0.99998f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_02_r", new BoneTransformData(HumanBodyBones.RightThumbIntermediate, new Vector3(0.04f, 0.00f, 0.00f), new Quaternion(0.03502f, 0.00249f, 0.02350f, 0.99911f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thumb_03_r", new BoneTransformData(HumanBodyBones.RightThumbDistal, new Vector3(0.03f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.05234f, 0.99863f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"weapon_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.01f, -0.01f), new Quaternion(-0.08981f, 0.14388f, -0.05929f, 0.98373f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"wrist_inner_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, -0.02f, 0.00f), new Quaternion(-0.71632f, -0.08078f, -0.11610f, 0.68329f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"wrist_outer_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.02f, 0.00f), new Quaternion(0.68329f, -0.11610f, 0.08078f, 0.71632f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_correctiveRoot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.01175f, 0.01521f, -0.00018f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_bck_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.05f, 0.01f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_fwd_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, 0.04f, 0.00f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_in_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.01f, 0.04f), new Quaternion(1.00000f, 0.00000f, 0.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_out_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.01f, -0.03f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.18f, 0.00f, 0.00f), new Quaternion(0.01148f, 0.01488f, -0.01749f, 0.99967f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"lowerarm_twist_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.09f, 0.00f, 0.00f), new Quaternion(0.01148f, 0.01488f, -0.01749f, 0.99967f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_correctiveRoot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_bck_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, -0.08f, -0.01f), new Quaternion(-0.58311f, 0.00000f, 0.00000f, 0.81240f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_fwd_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.03f, 0.09f, 0.01f), new Quaternion(0.75705f, -0.06762f, -0.08010f, 0.64489f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_in_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.07f, 0.01f, 0.05f), new Quaternion(0.91286f, 0.00000f, -0.40828f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_out_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, -0.06f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.09f, 0.00f, 0.00f), new Quaternion(-0.00005f, 0.01879f, 0.00285f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twistCor_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00005f, 0.01879f, 0.00285f, 0.99982f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twist_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.19f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_bicep_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, 0.04f, 0.02f), new Quaternion(0.67587f, -0.00239f, -0.00809f, 0.73698f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_tricep_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.05f, 0.00f), new Quaternion(-0.73698f, 0.00809f, -0.00239f, 0.67587f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"upperarm_twistCor_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(-0.00016f, 0.05634f, 0.00854f, 0.99837f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"neck_01", new BoneTransformData(HumanBodyBones.Neck, new Vector3(-0.12f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.20730f, 0.97828f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"neck_02", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.01670f, 0.99986f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"head", new BoneTransformData(HumanBodyBones.Head, new Vector3(-0.05f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, -0.10349f, 0.99463f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_04_latissimus_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.10f, 0.05f, -0.15f), new Quaternion(0.16731f, -0.75772f, -0.01926f, 0.63047f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"spine_04_latissimus_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.10f, 0.05f, 0.15f), new Quaternion(0.73204f, 0.04705f, 0.67508f, -0.07852f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_l", new BoneTransformData(HumanBodyBones.LeftUpperLeg, new Vector3(0.02f, 0.00f, -0.10f), new Quaternion(0.00343f, 0.00987f, 0.04834f, 0.99878f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_l", new BoneTransformData(HumanBodyBones.LeftLowerLeg, new Vector3(0.43f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00877f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_correctiveRoot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00002f, 0.00134f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_knee_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.05f, 0.00f), new Quaternion(0.72017f, 0.02153f, 0.01299f, 0.69334f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_kneeBack_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.06f, 0.00f), new Quaternion(-0.69334f, -0.01299f, 0.02153f, 0.72017f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.28f, 0.00f, 0.00f), new Quaternion(-0.00009f, -0.00225f, -0.02325f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.14f, 0.00f, 0.00f), new Quaternion(-0.00009f, -0.00225f, -0.02325f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twistCor_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"foot_l", new BoneTransformData(HumanBodyBones.LeftFoot, new Vector3(0.42f, 0.00f, 0.00f), new Quaternion(0.01763f, -0.00954f, -0.00625f, 0.99978f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ankle_bck_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.03f, 0.00f), new Quaternion(-0.75016f, -0.00198f, 0.05031f, 0.65933f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ankle_fwd_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.02f, -0.05f, 0.00f), new Quaternion(0.65933f, 0.05031f, 0.00198f, 0.75016f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ball_l", new BoneTransformData(HumanBodyBones.LeftToes, new Vector3(0.07f, -0.15f, 0.01f), new Quaternion(0.00000f, 0.00000f, 0.70711f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_correctiveRoot_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_bck_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.05f, 0.10f, 0.01f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_bck_lwr_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.05f, 0.10f, 0.01f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_fwd_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.04f, -0.07f, 0.01f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_fwd_lwr_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.07f, 0.01f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_in_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.11f, -0.01f, 0.09f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_out_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.06f, 0.01f, -0.05f), new Quaternion(1.00000f, 0.00000f, 0.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.14f, 0.00f, 0.00f), new Quaternion(0.00003f, -0.00225f, 0.01141f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twistCor_01_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.29f, 0.00f, 0.00f), new Quaternion(0.00003f, -0.00225f, 0.01141f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twistCor_02_l", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_r", new BoneTransformData(HumanBodyBones.RightUpperLeg, new Vector3(0.02f, 0.00f, 0.10f), new Quaternion(0.01016f, 0.00246f, -0.99877f, 0.04840f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_r", new BoneTransformData(HumanBodyBones.RightLowerLeg, new Vector3(-0.43f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00877f, 0.99996f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_correctiveRoot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00002f, 0.00134f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_knee_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.05f, 0.00f), new Quaternion(0.72017f, 0.02153f, 0.01300f, 0.69334f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_kneeBack_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, -0.06f, 0.00f), new Quaternion(-0.69334f, -0.01300f, 0.02153f, 0.72017f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.28f, 0.00f, 0.00f), new Quaternion(-0.00009f, -0.00225f, -0.02325f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twist_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.14f, 0.00f, 0.00f), new Quaternion(-0.00009f, -0.00225f, -0.02325f, 0.99973f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"calf_twistCor_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"foot_r", new BoneTransformData(HumanBodyBones.RightFoot, new Vector3(-0.42f, 0.00f, 0.00f), new Quaternion(0.01763f, -0.00954f, -0.00625f, 0.99978f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ankle_bck_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.01f, -0.04f, 0.01f), new Quaternion(-0.70213f, -0.00551f, 0.05005f, 0.71026f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ankle_fwd_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.02f, 0.05f, 0.00f), new Quaternion(0.71026f, 0.05005f, 0.00551f, 0.70213f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"ball_r", new BoneTransformData(HumanBodyBones.RightToes, new Vector3(-0.07f, 0.15f, -0.01f), new Quaternion(0.00000f, 0.00000f, 0.70711f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_correctiveRoot_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_bck_lwr_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.05f, -0.11f, -0.01f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_bck_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.05f, -0.10f, -0.02f), new Quaternion(-0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_fwd_lwr_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.01f, 0.07f, -0.01f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_fwd_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.04f, 0.07f, -0.01f), new Quaternion(0.70711f, 0.00000f, 0.00000f, 0.70711f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_in_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.11f, 0.01f, -0.09f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_out_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.06f, -0.01f, 0.05f), new Quaternion(1.00000f, 0.00000f, 0.00000f, 0.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.14f, 0.00f, 0.00f), new Quaternion(0.00003f, -0.00225f, 0.01141f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twistCor_01_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twist_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(-0.29f, 0.00f, 0.00f), new Quaternion(0.00003f, -0.00225f, 0.01141f, 0.99993f), new Vector3(1.00f, 1.00f, 1.00f))},
        {"thigh_twistCor_02_r", new BoneTransformData(HumanBodyBones.LastBone, new Vector3(0.00f, 0.00f, 0.00f), new Quaternion(0.00000f, 0.00000f, 0.00000f, 1.00000f), new Vector3(1.00f, 1.00f, 1.00f))}
    };
}