﻿using System;
using System.IO;
using System.Linq;
using UnityEngine;
using UnityEditor;
using System.Collections.Generic;

namespace Movella.Xsens.Editor
{
    public static class SaiDev
    {
        // used for dev purposes of getting rig values to store as variables
        public static void PrintAllBones(GameObject obj)
        {
            if (obj == null)
            {
                Debug.LogError("GameObject is null.");
                return;
            }

            Animator animator = obj.GetComponent<Animator>();
            Dictionary<Transform, HumanBodyBones?> humanBoneMapping = new Dictionary<Transform, HumanBodyBones?>();

            // Map each human bone to its Transform (if available)
            if (animator != null && animator.isHuman)
            {
                foreach (HumanBodyBones bone in (HumanBodyBones[])Enum.GetValues(typeof(HumanBodyBones)))
                {
                    if (bone == HumanBodyBones.LastBone) continue;
                    Transform boneTransform = animator.GetBoneTransform(bone);
                    if (boneTransform != null && !humanBoneMapping.ContainsKey(boneTransform))
                    {
                        humanBoneMapping[boneTransform] = bone;
                    }
                }
            }

            List<string> boneData = new List<string>();
            TraverseBones(obj.transform, humanBoneMapping, boneData);

            // Get desktop path and create a file with the GameObject's name
            string desktopPath = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            string fileName = obj.name.Replace(" ", "_") + "_BoneData.txt";
            string filePath = Path.Combine(desktopPath, fileName);

            // Write to file
            File.WriteAllLines(filePath, boneData);

            Debug.Log($"Bone data saved to: {filePath}");
        }

        private static void TraverseBones(Transform bone, Dictionary<Transform, HumanBodyBones?> humanBoneMapping, List<string> boneData)
        {
            HumanBodyBones? humanBone = humanBoneMapping.ContainsKey(bone) ? humanBoneMapping[bone] : null;
            Vector3 position = bone.localPosition;
            Quaternion rotation = bone.localRotation;
            Vector3 scale = bone.localScale;

            boneData.Add($"{{\"{bone.name}\", new BoneTransformData({(humanBone.HasValue ? $"HumanBodyBones.{humanBone.Value}" : "HumanBodyBones.LastBone")}, " +
                         $"new Vector3({position.x:F2}f, {position.y:F2}f, {position.z:F2}f), " +
                         $"new Quaternion({rotation.x:F5}f, {rotation.y:F5}f, {rotation.z:F5}f, {rotation.w:F5}f), " +
                         $"new Vector3({scale.x:F2}f, {scale.y:F2}f, {scale.z:F2}f))}},");

            foreach (Transform child in bone)
            {
                TraverseBones(child, humanBoneMapping, boneData);
            }
        }
    }
}