﻿// This Is not used at all. Keeping here temporarily for reference
using System;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;
using Object = UnityEngine.Object;

public class AddPrefabTargetDialog : EditorWindow
{
    private Object _selection;
    private Action<Object> _onPrefabSelected;
    private List<GameObject> _rootPrefabsInScene;

    public static void ShowWindow(Action<Object> onPrefabSelected)
    {
        var window = GetWindow<AddPrefabTargetDialog>("Add Target Prefab");
        window._onPrefabSelected = onPrefabSelected;
        window.minSize = new Vector2(150, 70);
        window.maxSize = new Vector2(600, 70);

    }

    private void OnEnable()
    {
        var allObjects = FindObjectsByType<GameObject>(FindObjectsSortMode.None);
        _rootPrefabsInScene = new List<GameObject>();

        foreach (var obj in allObjects)
        {
            if (PrefabUtility.IsAnyPrefabInstanceRoot(obj))
            {
                _rootPrefabsInScene.Add(obj);
            }
        } 
    }

    private void OnGUI()
    {
        string[] prefabNames = _rootPrefabsInScene.ConvertAll(prefab => prefab.name).ToArray();
        int selectedIndex = Mathf.Max(0, Array.IndexOf(prefabNames, _selection != null ? _selection.name : null));
        selectedIndex = EditorGUILayout.Popup("Select Prefab", selectedIndex, prefabNames);

        _selection = _rootPrefabsInScene.Count > 0 ? _rootPrefabsInScene[selectedIndex] : null;

        // GUILayout.BeginHorizontal();
        if (GUILayout.Button("Add as Character "))
        {
            _onPrefabSelected?.Invoke(_selection);
            Close();
        }
        if (GUILayout.Button("   Add as Prop   "))
        {
            _onPrefabSelected?.Invoke(_selection);
            Close();
        }
        // GUILayout.EndHorizontal();
    }
}